/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.groups;

import java.util.List;
import java.util.stream.Collectors;
import shadow.org.assertj.core.api.iterable.Extractor;
import shadow.org.assertj.core.util.IterableUtil;
import shadow.org.assertj.core.util.Lists;
import shadow.org.assertj.core.util.Streams;

public class FieldsOrPropertiesExtractor {
    public static <F, T> T[] extract(F[] objects, Extractor<? super F, T> extractor) {
        FieldsOrPropertiesExtractor.checkObjectToExtractFromIsNotNull(objects);
        List<T> result = FieldsOrPropertiesExtractor.extract(Lists.newArrayList(objects), extractor);
        return IterableUtil.toArray(result);
    }

    public static <F, T> List<T> extract(Iterable<? extends F> objects, Extractor<? super F, T> extractor) {
        FieldsOrPropertiesExtractor.checkObjectToExtractFromIsNotNull(objects);
        return Streams.stream(objects).map(extractor::extract).collect(Collectors.toList());
    }

    private static void checkObjectToExtractFromIsNotNull(Object object) {
        if (object == null) {
            throw new AssertionError((Object)"Expecting actual not to be null");
        }
    }
}

