/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.util;

import shadow.org.assertj.core.util.NullSafeComparator;

public class FloatComparator
extends NullSafeComparator<Float> {
    private float precision;

    public FloatComparator(float epsilon) {
        this.precision = epsilon;
    }

    public float getEpsilon() {
        return this.precision;
    }

    @Override
    public int compareNonNull(Float x, Float y) {
        if (this.closeEnough(x, y, this.precision)) {
            return 0;
        }
        return x.floatValue() < y.floatValue() ? -1 : 1;
    }

    private boolean closeEnough(Float x, Float y, float epsilon) {
        return Math.abs(x.floatValue() - y.floatValue()) <= epsilon;
    }

    public int hashCode() {
        return 31 + Float.floatToIntBits(this.precision);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatComparator)) {
            return false;
        }
        FloatComparator other = (FloatComparator)obj;
        return Float.floatToIntBits(this.precision) == Float.floatToIntBits(other.precision);
    }

    public String toString() {
        return String.format("FloatComparator[precision=%s]", Float.valueOf(this.precision));
    }
}

