/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.util.diff;

import java.util.List;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.diff.Chunk;
import shadow.org.assertj.core.util.diff.Delta;

public class InsertDelta<T>
extends Delta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        List lines = this.getRevised().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    public void verify(List<T> target) throws IllegalStateException {
        Preconditions.checkState(this.getOriginal().getPosition() <= target.size(), "Incorrect patch for delta: delta original position > target size", new Object[0]);
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.INSERT;
    }
}

