/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotProperties;
import au.com.origin.snapshots.SnapshotVerifier;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class Expect {
    private final SnapshotVerifier snapshotVerifier;
    private final Method testMethod;
    private SnapshotSerializer snapshotSerializer;
    private SnapshotComparator snapshotComparator;
    private List<SnapshotReporter> snapshotReporters;
    private String scenario;

    public static Expect of(SnapshotVerifier snapshotVerifier, Method method) {
        return new Expect(snapshotVerifier, method);
    }

    public void toMatchSnapshot(Object object) {
        this.toMatchSnapshotLegacy(object, new Object[0]);
    }

    @Deprecated
    public void toMatchSnapshotLegacy(Object firstObject, Object ... objects) {
        Snapshot snapshot = this.snapshotVerifier.expectCondition(this.testMethod, firstObject, objects);
        if (this.snapshotSerializer != null) {
            snapshot.setSnapshotSerializer(this.snapshotSerializer);
        }
        if (this.snapshotComparator != null) {
            snapshot.setSnapshotComparator(this.snapshotComparator);
        }
        if (this.snapshotReporters != null) {
            snapshot.setSnapshotReporters(this.snapshotReporters);
        }
        if (this.scenario != null) {
            snapshot.setScenario(this.scenario);
        }
        snapshot.toMatchSnapshot();
    }

    public Expect scenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    public Expect serializer(SnapshotSerializer serializer) {
        this.snapshotSerializer = serializer;
        return this;
    }

    public Expect serializer(String name) {
        this.snapshotSerializer = (SnapshotSerializer)SnapshotProperties.getInstance("serializer." + name);
        return this;
    }

    public Expect comparator(SnapshotComparator comparator) {
        this.snapshotComparator = comparator;
        return this;
    }

    public Expect reporters(SnapshotReporter ... reporters) {
        this.snapshotReporters = Arrays.asList(reporters);
        return this;
    }

    public Expect serializer(Class<? extends SnapshotSerializer> serializer) {
        this.snapshotSerializer = serializer.getConstructor(new Class[0]).newInstance(new Object[0]);
        return this;
    }

    public Expect(SnapshotVerifier snapshotVerifier, Method testMethod) {
        this.snapshotVerifier = snapshotVerifier;
        this.testMethod = testMethod;
    }
}

