/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.SnapshotConfig;
import au.com.origin.snapshots.SnapshotFile;
import au.com.origin.snapshots.annotations.SnapshotName;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snapshot {
    private static final Logger log = LoggerFactory.getLogger(Snapshot.class);
    private final SnapshotConfig snapshotConfig;
    private final SnapshotFile snapshotFile;
    private final Class<?> testClass;
    private final Method testMethod;
    private final Object[] current;
    private final boolean isCI;
    private SnapshotSerializer snapshotSerializer;
    private SnapshotComparator snapshotComparator;
    private List<SnapshotReporter> snapshotReporters;
    private String scenario;

    Snapshot(SnapshotConfig snapshotConfig, SnapshotFile snapshotFile, Class<?> testClass, Method testMethod, Object ... current) {
        this.snapshotConfig = snapshotConfig;
        this.snapshotFile = snapshotFile;
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.current = current;
        this.isCI = snapshotConfig.isCI();
        this.snapshotSerializer = snapshotConfig.getSerializer();
        this.snapshotComparator = snapshotConfig.getComparator();
        this.snapshotReporters = snapshotConfig.getReporters();
        this.scenario = null;
    }

    public void toMatchSnapshot() {
        Set<String> rawSnapshots = this.snapshotFile.getRawSnapshots();
        String rawSnapshot = this.getRawSnapshot(rawSnapshots);
        String currentObject = this.takeSnapshot();
        if (rawSnapshot != null && this.shouldUpdateSnapshot()) {
            this.snapshotFile.getRawSnapshots().remove(rawSnapshot);
            rawSnapshot = null;
        }
        if (rawSnapshot != null) {
            if (!this.snapshotComparator.matches(this.getSnapshotName(), rawSnapshot, currentObject)) {
                this.snapshotFile.createDebugFile(currentObject.trim());
                List reporters = this.snapshotReporters.stream().filter(reporter -> reporter.supportsFormat(this.snapshotSerializer.getOutputFormat())).collect(Collectors.toList());
                if (reporters.isEmpty()) {
                    String comparator = this.snapshotComparator.getClass().getSimpleName();
                    throw new IllegalStateException("No compatible reporters found for comparator " + comparator);
                }
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                for (SnapshotReporter reporter2 : reporters) {
                    try {
                        reporter2.report(this.getSnapshotName(), rawSnapshot, currentObject);
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new SnapshotMatchException("Error(s) matching snapshot(s)", (List<Throwable>)errors);
                }
            }
        } else {
            if (this.isCI) {
                log.error("We detected you are running on a CI Server - if this is incorrect please override the isCI() method in SnapshotConfig");
                throw new SnapshotMatchException("Snapshot [" + this.getSnapshotName() + "] not found. Has this snapshot been committed ?");
            }
            log.warn("We detected you are running on a developer machine - if this is incorrect please override the isCI() method in SnapshotConfig");
            this.snapshotFile.push(currentObject);
        }
        this.snapshotFile.deleteDebugFile();
    }

    private boolean shouldUpdateSnapshot() {
        if (this.snapshotConfig.updateSnapshot().isPresent()) {
            return this.getSnapshotName().contains(this.snapshotConfig.updateSnapshot().get());
        }
        return false;
    }

    private String getRawSnapshot(Collection<String> rawSnapshots) {
        for (String rawSnapshot : rawSnapshots) {
            if (!rawSnapshot.contains(this.getSnapshotName())) continue;
            return rawSnapshot;
        }
        return null;
    }

    private String takeSnapshot() {
        return this.getSnapshotName() + (String)this.snapshotSerializer.apply(this.current);
    }

    String getSnapshotName() {
        String scenarioFormat = this.scenario == null ? "" : "[" + this.scenario + "]";
        SnapshotName snapshotName = this.testMethod.getAnnotation(SnapshotName.class);
        String pathFormat = snapshotName == null ? this.testClass.getName() + "." + this.testMethod.getName() : snapshotName.value();
        return pathFormat + scenarioFormat + "=";
    }

    public void setSnapshotSerializer(SnapshotSerializer snapshotSerializer) {
        this.snapshotSerializer = snapshotSerializer;
    }

    public void setSnapshotComparator(SnapshotComparator snapshotComparator) {
        this.snapshotComparator = snapshotComparator;
    }

    public void setSnapshotReporters(List<SnapshotReporter> snapshotReporters) {
        this.snapshotReporters = snapshotReporters;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }
}

