/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFile {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFile.class);
    public static final String SPLIT_STRING = "\n\n\n";
    private final String fileName;
    private final Class<?> testClass;
    private final BiFunction<Class<?>, String, String> onSaveSnapshotFile;
    private Set<String> rawSnapshots;

    SnapshotFile(String srcDirPath, String fileName, Class<?> testClass, BiFunction<Class<?>, String, String> onSaveSnapshotFile) throws IOException {
        this.testClass = testClass;
        this.onSaveSnapshotFile = onSaveSnapshotFile;
        this.fileName = srcDirPath + File.separator + fileName;
        log.info("Snapshot File: " + this.fileName);
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), StandardCharsets.UTF_8));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                fileContent.append(sCurrentLine + "\n");
            }
            String fileText = fileContent.toString();
            this.rawSnapshots = !"".equals(fileText.trim()) ? Collections.synchronizedSortedSet(Stream.of(fileContent.toString().split(SPLIT_STRING)).map(String::trim).collect(Collectors.toCollection(TreeSet::new))) : Collections.synchronizedSortedSet(new TreeSet());
        }
        catch (IOException e) {
            this.rawSnapshots = Collections.synchronizedSortedSet(new TreeSet());
        }
    }

    private String getDebugFilename() {
        return this.fileName + ".debug";
    }

    public File createDebugFile(String snapshot) {
        File file = null;
        try {
            file = new File(this.getDebugFilename());
            file.getParentFile().mkdirs();
            file.createNewFile();
            try (FileOutputStream fileStream = new FileOutputStream(file, false);){
                fileStream.write(snapshot.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void deleteDebugFile() {
        Files.deleteIfExists(Paths.get(this.getDebugFilename(), new String[0]));
    }

    public void delete() {
        Files.deleteIfExists(Paths.get(this.fileName, new String[0]));
    }

    public synchronized File createFileIfNotExists() {
        Path path = Paths.get(this.fileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        return path.toFile();
    }

    public void push(String snapshot) {
        this.rawSnapshots.add(snapshot);
        File file = this.createFileIfNotExists();
        try (FileOutputStream fileStream = new FileOutputStream(file, false);){
            byte[] myBytes = String.join((CharSequence)SPLIT_STRING, this.rawSnapshots).getBytes(StandardCharsets.UTF_8);
            fileStream.write(myBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
        Path path = Paths.get(this.fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.size(path) == 0L) {
                this.deleteDebugFile();
                this.delete();
            } else {
                String content = new String(Files.readAllBytes(Paths.get(this.fileName, new String[0])), StandardCharsets.UTF_8);
                String modified = this.onSaveSnapshotFile.apply(this.testClass, content);
                Files.write(path, modified.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    public Set<String> getRawSnapshots() {
        return this.rawSnapshots;
    }
}

