/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotConfig;
import au.com.origin.snapshots.SnapshotFile;
import au.com.origin.snapshots.annotations.SnapshotName;
import au.com.origin.snapshots.annotations.UseSnapshotConfig;
import au.com.origin.snapshots.exceptions.SnapshotExtensionException;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotVerifier {
    private static final Logger log = LoggerFactory.getLogger(SnapshotVerifier.class);
    private final Class<?> testClass;
    private final SnapshotFile snapshotFile;
    private final SnapshotConfig config;
    private final boolean failOnOrphans;
    private final Collection<Snapshot> calledSnapshots = Collections.synchronizedCollection(new ArrayList());

    public SnapshotVerifier(SnapshotConfig frameworkSnapshotConfig, Class<?> testClass) {
        this(frameworkSnapshotConfig, testClass, false);
    }

    public SnapshotVerifier(SnapshotConfig frameworkSnapshotConfig, Class<?> testClass, boolean failOnOrphans) {
        try {
            this.verifyNoConflictingSnapshotNames(testClass);
            UseSnapshotConfig customConfig = testClass.getAnnotation(UseSnapshotConfig.class);
            SnapshotConfig snapshotConfig = customConfig == null ? frameworkSnapshotConfig : customConfig.value().newInstance();
            String testFilename = testClass.getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".snap";
            File fileUnderTest = new File(testFilename);
            File snapshotDir = new File(fileUnderTest.getParentFile(), snapshotConfig.getSnapshotDir());
            String testSrcDir = snapshotConfig.getOutputDir();
            String testSrcDirNoTrailing = testSrcDir.endsWith("/") ? testSrcDir.substring(0, testSrcDir.length() - 1) : testSrcDir;
            SnapshotFile snapshotFile = new SnapshotFile(testSrcDirNoTrailing, snapshotDir.getPath() + File.separator + fileUnderTest.getName(), testClass, snapshotConfig::onSaveSnapshotFile);
            this.testClass = testClass;
            this.snapshotFile = snapshotFile;
            this.config = snapshotConfig;
            this.failOnOrphans = failOnOrphans;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new SnapshotExtensionException(e.getMessage());
        }
    }

    private void verifyNoConflictingSnapshotNames(Class<?> testClass) {
        boolean hasDuplicateSnapshotNames;
        Map<String, List<String>> allSnapshotAnnotationNames = Arrays.stream(testClass.getDeclaredMethods()).filter(it -> it.isAnnotationPresent(SnapshotName.class)).map(it -> it.getAnnotation(SnapshotName.class)).map(SnapshotName::value).collect(Collectors.groupingBy(String::toString));
        boolean bl = hasDuplicateSnapshotNames = allSnapshotAnnotationNames.entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).peek(it -> log.error("Oops, looks like you set the same name of two separate snapshots @SnapshotName(\"{}\") in class {}", it.getKey(), (Object)testClass.getName())).count() > 0L;
        if (hasDuplicateSnapshotNames) {
            throw new SnapshotExtensionException("Duplicate @SnapshotName annotations found!");
        }
    }

    public Snapshot expectCondition(Method testMethod, Object firstObject, Object ... others) {
        Object[] objects = this.mergeObjects(firstObject, others);
        Snapshot snapshot = new Snapshot(this.config, this.snapshotFile, this.testClass, testMethod, objects);
        this.calledSnapshots.add(snapshot);
        return snapshot;
    }

    public void validateSnapshots() {
        Set<String> rawSnapshots = this.snapshotFile.getRawSnapshots();
        Set snapshotNames = this.calledSnapshots.stream().map(Snapshot::getSnapshotName).collect(Collectors.toSet());
        ArrayList<String> unusedRawSnapshots = new ArrayList<String>();
        for (String rawSnapshot : rawSnapshots) {
            boolean foundSnapshot = false;
            for (String snapshotName : snapshotNames) {
                if (!rawSnapshot.contains(snapshotName)) continue;
                foundSnapshot = true;
                break;
            }
            if (foundSnapshot) continue;
            unusedRawSnapshots.add(rawSnapshot);
        }
        if (unusedRawSnapshots.size() > 0) {
            String errorMessage = "All unused Snapshots:\n" + String.join((CharSequence)"\n", unusedRawSnapshots) + "\n\nHave you deleted tests? Have you renamed a test method?";
            if (this.failOnOrphans) {
                log.error(errorMessage);
                throw new SnapshotMatchException("ERROR: Found orphan snapshots");
            }
            log.warn(errorMessage);
        }
        this.snapshotFile.cleanup();
    }

    private Object[] mergeObjects(Object firstObject, Object[] others) {
        Object[] objects = new Object[]{firstObject};
        if (!shadow.org.assertj.core.util.Arrays.isNullOrEmpty(others)) {
            objects = Stream.concat(Arrays.stream(objects), Arrays.stream(others)).toArray(Object[]::new);
        }
        return objects;
    }

    public SnapshotVerifier(Class<?> testClass, SnapshotFile snapshotFile, SnapshotConfig config, boolean failOnOrphans) {
        this.testClass = testClass;
        this.snapshotFile = snapshotFile;
        this.config = config;
        this.failOnOrphans = failOnOrphans;
    }
}

