/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.serializers;

import au.com.origin.snapshots.serializers.SerializerType;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStringSnapshotSerializer
implements SnapshotSerializer {
    private static final Logger log = LoggerFactory.getLogger(ToStringSnapshotSerializer.class);

    @Override
    public String apply(Object[] objects) {
        return "[\n" + Arrays.stream(objects).map(Object::toString).map(it -> {
            if (it.contains("\n\n\n")) {
                log.warn("Found 3 consecutive lines in your snapshot \\n\\n\\n. This sequence is reserved as the snapshot separator - replacing with \\n.\\n.\\n");
                return it.replaceAll("\n\n\n", "\n.\n.\n");
            }
            return it;
        }).collect(Collectors.joining("\n")) + "\n]";
    }

    @Override
    public String getOutputFormat() {
        return SerializerType.TEXT.name();
    }
}

