/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.condition;

import shadow.org.assertj.core.api.Condition;
import shadow.org.assertj.core.condition.Join;

public class AnyOf<T>
extends Join<T> {
    @SafeVarargs
    public static <T> Condition<T> anyOf(Condition<? super T> ... conditions) {
        return new AnyOf<T>(conditions);
    }

    public static <T> Condition<T> anyOf(Iterable<? extends Condition<? super T>> conditions) {
        return new AnyOf<T>(conditions);
    }

    @SafeVarargs
    private AnyOf(Condition<? super T> ... conditions) {
        super(conditions);
    }

    private AnyOf(Iterable<? extends Condition<? super T>> conditions) {
        super(conditions);
    }

    @Override
    public boolean matches(T value) {
        return this.conditions.stream().anyMatch(condition -> condition.matches(value));
    }

    @Override
    public String toString() {
        return String.format("any of:<%s>", this.conditions);
    }
}

