/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import java.util.concurrent.Future;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.error.future.ShouldBeCancelled;
import shadow.org.assertj.core.error.future.ShouldBeDone;
import shadow.org.assertj.core.error.future.ShouldNotBeCancelled;
import shadow.org.assertj.core.error.future.ShouldNotBeDone;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.util.VisibleForTesting;

public class Futures {
    private static final Futures INSTANCE = new Futures();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Futures instance() {
        return INSTANCE;
    }

    public void assertIsCancelled(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isCancelled()) {
            throw this.failures.failure(info, ShouldBeCancelled.shouldBeCancelled(actual));
        }
    }

    public void assertIsNotCancelled(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isCancelled()) {
            throw this.failures.failure(info, ShouldNotBeCancelled.shouldNotBeCancelled(actual));
        }
    }

    public void assertIsDone(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isDone()) {
            throw this.failures.failure(info, ShouldBeDone.shouldBeDone(actual));
        }
    }

    public void assertIsNotDone(AssertionInfo info, Future<?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isDone()) {
            throw this.failures.failure(info, ShouldNotBeDone.shouldNotBeDone(actual));
        }
    }

    private void assertNotNull(AssertionInfo info, Future<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

