/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import shadow.org.assertj.core.util.Streams;

public final class Lists {
    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<T> list = Lists.newArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> list(T ... elements) {
        return Lists.newArrayList(elements);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> elements) {
        if (elements == null) {
            return null;
        }
        return Streams.stream(elements).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> newArrayList(Iterator<? extends T> elements) {
        if (elements == null) {
            return null;
        }
        return Streams.stream(elements).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    private Lists() {
    }
}

