/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import shadow.org.assertj.core.util.Preconditions;

public class URLs {
    private URLs() {
    }

    public static String contentOf(URL url, String charsetName) {
        URLs.checkArgumentCharsetIsSupported(charsetName);
        return URLs.contentOf(url, Charset.forName(charsetName));
    }

    public static String contentOf(URL url, Charset charset) {
        Preconditions.checkNotNull(charset, "The charset should not be null");
        try {
            return URLs.loadContents(url.openStream(), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + url, e);
        }
    }

    public static List<String> linesOf(URL url, Charset charset) {
        Preconditions.checkNotNull(charset, "The charset should not be null");
        try {
            return URLs.loadLines(url.openStream(), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + url, e);
        }
    }

    public static List<String> linesOf(URL url, String charsetName) {
        URLs.checkArgumentCharsetIsSupported(charsetName);
        return URLs.linesOf(url, Charset.forName(charsetName));
    }

    /*
     * Exception decompiling
     */
    private static String loadContents(InputStream stream, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> loadLines(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    private static void checkArgumentCharsetIsSupported(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
    }
}

