/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotFile;
import au.com.origin.snapshots.SnapshotHeader;
import au.com.origin.snapshots.SnapshotSerializerContext;
import au.com.origin.snapshots.annotations.SnapshotName;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.config.SnapshotConfig;
import au.com.origin.snapshots.exceptions.ReservedWordException;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotContext {
    private static final Logger log = LoggerFactory.getLogger(SnapshotContext.class);
    private static final List<String> RESERVED_WORDS = Arrays.asList("=", "[", "]");
    private final SnapshotConfig snapshotConfig;
    private final SnapshotFile snapshotFile;
    final Class<?> testClass;
    final Method testMethod;
    final Object current;
    private final boolean isCI;
    private SnapshotSerializer snapshotSerializer;
    private SnapshotComparator snapshotComparator;
    private List<SnapshotReporter> snapshotReporters;
    String scenario;
    SnapshotHeader header = new SnapshotHeader();

    SnapshotContext(SnapshotConfig snapshotConfig, SnapshotFile snapshotFile, Class<?> testClass, Method testMethod, Object current) {
        this.snapshotConfig = snapshotConfig;
        this.snapshotFile = snapshotFile;
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.current = current;
        this.isCI = snapshotConfig.isCI();
        this.snapshotSerializer = snapshotConfig.getSerializer();
        this.snapshotComparator = snapshotConfig.getComparator();
        this.snapshotReporters = snapshotConfig.getReporters();
        this.scenario = null;
    }

    public void toMatchSnapshot() {
        Set<Snapshot> rawSnapshots = this.snapshotFile.getSnapshots();
        Snapshot previousSnapshot = this.getRawSnapshot(rawSnapshots);
        Snapshot currentSnapshot = this.takeSnapshot();
        if (previousSnapshot != null && this.shouldUpdateSnapshot()) {
            this.snapshotFile.getSnapshots().remove(previousSnapshot);
            previousSnapshot = null;
        }
        if (previousSnapshot != null) {
            this.snapshotFile.pushDebugSnapshot(currentSnapshot);
            if (!this.snapshotComparator.matches(previousSnapshot, currentSnapshot)) {
                this.snapshotFile.createDebugFile(currentSnapshot);
                List reporters = this.snapshotReporters.stream().filter(reporter -> reporter.supportsFormat(this.snapshotSerializer.getOutputFormat())).collect(Collectors.toList());
                if (reporters.isEmpty()) {
                    String comparator = this.snapshotComparator.getClass().getSimpleName();
                    throw new IllegalStateException("No compatible reporters found for comparator " + comparator);
                }
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                for (SnapshotReporter reporter2 : reporters) {
                    try {
                        reporter2.report(previousSnapshot, currentSnapshot);
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new SnapshotMatchException("Error(s) matching snapshot(s)", (List<Throwable>)errors);
                }
            }
        } else {
            if (this.isCI) {
                log.error("We detected you are running on a CI Server - if this is incorrect please override the isCI() method in SnapshotConfig");
                throw new SnapshotMatchException("Snapshot [" + this.resolveSnapshotIdentifier() + "] not found. Has this snapshot been committed ?");
            }
            log.warn("We detected you are running on a developer machine - if this is incorrect please override the isCI() method in SnapshotConfig");
            this.snapshotFile.pushSnapshot(currentSnapshot);
            this.snapshotFile.pushDebugSnapshot(currentSnapshot);
        }
    }

    private boolean shouldUpdateSnapshot() {
        if (this.snapshotConfig.updateSnapshot().isPresent()) {
            return this.resolveSnapshotIdentifier().contains(this.snapshotConfig.updateSnapshot().get());
        }
        return false;
    }

    private Snapshot getRawSnapshot(Collection<Snapshot> rawSnapshots) {
        for (Snapshot rawSnapshot : rawSnapshots) {
            if (!rawSnapshot.getIdentifier().equals(this.resolveSnapshotIdentifier())) continue;
            return rawSnapshot;
        }
        return null;
    }

    private Snapshot takeSnapshot() {
        SnapshotSerializerContext sg = SnapshotSerializerContext.from(this);
        return (Snapshot)this.snapshotSerializer.apply(this.current, sg);
    }

    String resolveSnapshotIdentifier() {
        String scenarioFormat = this.scenario == null ? "" : "[" + this.scenario + "]";
        return this.snapshotName() + scenarioFormat;
    }

    private String snapshotName() {
        SnapshotName snapshotName = this.testMethod.getAnnotation(SnapshotName.class);
        return snapshotName == null ? this.testClass.getName() + "." + this.testMethod.getName() : snapshotName.value();
    }

    void checkValidContext() {
        for (String rw : RESERVED_WORDS) {
            if (this.snapshotName().contains(rw)) {
                throw new ReservedWordException("snapshot name", rw, RESERVED_WORDS);
            }
            if (this.scenario == null || !this.scenario.contains(rw)) continue;
            throw new ReservedWordException("scenario name", rw, RESERVED_WORDS);
        }
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public void setSnapshotSerializer(SnapshotSerializer snapshotSerializer) {
        this.snapshotSerializer = snapshotSerializer;
    }

    public void setSnapshotComparator(SnapshotComparator snapshotComparator) {
        this.snapshotComparator = snapshotComparator;
    }

    public void setSnapshotReporters(List<SnapshotReporter> snapshotReporters) {
        this.snapshotReporters = snapshotReporters;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public String getScenario() {
        return this.scenario;
    }

    public SnapshotHeader getHeader() {
        return this.header;
    }
}

