/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.serializers;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotSerializerContext;
import au.com.origin.snapshots.serializers.SerializerType;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStringSnapshotSerializer
implements SnapshotSerializer {
    private static final Logger log = LoggerFactory.getLogger(ToStringSnapshotSerializer.class);

    @Override
    public Snapshot apply(Object object, SnapshotSerializerContext gen) {
        List<Object> objects = Arrays.asList(object);
        String body = "[\n" + objects.stream().map(Object::toString).map(it -> {
            if (it.contains("\n\n\n")) {
                log.warn("Found 3 consecutive lines in your snapshot \\n\\n\\n. This sequence is reserved as the snapshot separator - replacing with \\n.\\n.\\n");
                return it.replaceAll("\n\n\n", "\n.\n.\n");
            }
            return it;
        }).collect(Collectors.joining("\n")) + "\n]";
        return gen.toSnapshot(body);
    }

    @Override
    public String getOutputFormat() {
        return SerializerType.TEXT.name();
    }
}

