/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import shadow.org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import shadow.org.assertj.core.internal.bytebuddy.description.field.FieldDescription;
import shadow.org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import shadow.org.assertj.core.internal.bytebuddy.dynamic.Transformer;
import shadow.org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeWriter;
import shadow.org.assertj.core.internal.bytebuddy.implementation.attribute.FieldAttributeAppender;
import shadow.org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import shadow.org.assertj.core.internal.bytebuddy.matcher.LatentMatcher;

public interface FieldRegistry {
    public FieldRegistry prepend(LatentMatcher<? super FieldDescription> var1, FieldAttributeAppender.Factory var2, Object var3, Transformer<FieldDescription> var4);

    public Compiled compile(TypeDescription var1);

    @HashCodeAndEqualsPlugin.Enhance
    public static class Default
    implements FieldRegistry {
        private final List<Entry> entries;

        public Default() {
            this(Collections.emptyList());
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public FieldRegistry prepend(LatentMatcher<? super FieldDescription> matcher, FieldAttributeAppender.Factory fieldAttributeAppenderFactory, Object defaultValue, Transformer<FieldDescription> transformer) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.entries.size() + 1);
            entries.add(new Entry(matcher, fieldAttributeAppenderFactory, defaultValue, transformer));
            entries.addAll(this.entries);
            return new Default(entries);
        }

        @Override
        public shadow.org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled compile(TypeDescription instrumentedType) {
            ArrayList<Compiled.Entry> entries = new ArrayList<Compiled.Entry>(this.entries.size());
            HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender> fieldAttributeAppenders = new HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender>();
            for (Entry entry : this.entries) {
                FieldAttributeAppender fieldAttributeAppender = (FieldAttributeAppender)fieldAttributeAppenders.get(entry.getFieldAttributeAppenderFactory());
                if (fieldAttributeAppender == null) {
                    fieldAttributeAppender = entry.getFieldAttributeAppenderFactory().make(instrumentedType);
                    fieldAttributeAppenders.put(entry.getFieldAttributeAppenderFactory(), fieldAttributeAppender);
                }
                entries.add(new Compiled.Entry(entry.resolve(instrumentedType), fieldAttributeAppender, entry.getDefaultValue(), entry.getTransformer()));
            }
            return new Compiled(instrumentedType, entries);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.entries).equals(((Default)object).entries);
        }

        public int hashCode() {
            return 17 * 31 + ((Object)this.entries).hashCode();
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class Compiled
        implements shadow.org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final List<Entry> entries;

            protected Compiled(TypeDescription instrumentedType, List<Entry> entries) {
                this.instrumentedType = instrumentedType;
                this.entries = entries;
            }

            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(fieldDescription)) continue;
                    return entry.bind(this.instrumentedType, fieldDescription);
                }
                return new TypeWriter.FieldPool.Record.ForImplicitField(fieldDescription);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.instrumentedType.equals(((Compiled)object).instrumentedType)) {
                    return false;
                }
                return ((Object)this.entries).equals(((Compiled)object).entries);
            }

            public int hashCode() {
                return (17 * 31 + this.instrumentedType.hashCode()) * 31 + ((Object)this.entries).hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Entry
            implements ElementMatcher<FieldDescription> {
                private final ElementMatcher<? super FieldDescription> matcher;
                private final FieldAttributeAppender fieldAttributeAppender;
                private final Object defaultValue;
                private final Transformer<FieldDescription> transformer;

                protected Entry(ElementMatcher<? super FieldDescription> matcher, FieldAttributeAppender fieldAttributeAppender, Object defaultValue, Transformer<FieldDescription> transformer) {
                    this.matcher = matcher;
                    this.fieldAttributeAppender = fieldAttributeAppender;
                    this.defaultValue = defaultValue;
                    this.transformer = transformer;
                }

                protected TypeWriter.FieldPool.Record bind(TypeDescription instrumentedType, FieldDescription fieldDescription) {
                    return new TypeWriter.FieldPool.Record.ForExplicitField(this.fieldAttributeAppender, this.defaultValue, this.transformer.transform(instrumentedType, fieldDescription));
                }

                @Override
                public boolean matches(FieldDescription target) {
                    return this.matcher.matches(target);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.matcher.equals(((Entry)object).matcher)) {
                        return false;
                    }
                    if (!this.fieldAttributeAppender.equals(((Entry)object).fieldAttributeAppender)) {
                        return false;
                    }
                    if (!this.defaultValue.equals(((Entry)object).defaultValue)) {
                        return false;
                    }
                    return this.transformer.equals(((Entry)object).transformer);
                }

                public int hashCode() {
                    return (((17 * 31 + this.matcher.hashCode()) * 31 + this.fieldAttributeAppender.hashCode()) * 31 + this.defaultValue.hashCode()) * 31 + this.transformer.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class Entry
        implements LatentMatcher<FieldDescription> {
            private final LatentMatcher<? super FieldDescription> matcher;
            private final FieldAttributeAppender.Factory fieldAttributeAppenderFactory;
            private final Object defaultValue;
            private final Transformer<FieldDescription> transformer;

            protected Entry(LatentMatcher<? super FieldDescription> matcher, FieldAttributeAppender.Factory fieldAttributeAppenderFactory, Object defaultValue, Transformer<FieldDescription> transformer) {
                this.matcher = matcher;
                this.fieldAttributeAppenderFactory = fieldAttributeAppenderFactory;
                this.defaultValue = defaultValue;
                this.transformer = transformer;
            }

            protected FieldAttributeAppender.Factory getFieldAttributeAppenderFactory() {
                return this.fieldAttributeAppenderFactory;
            }

            protected Object getDefaultValue() {
                return this.defaultValue;
            }

            protected Transformer<FieldDescription> getTransformer() {
                return this.transformer;
            }

            @Override
            public ElementMatcher<? super FieldDescription> resolve(TypeDescription typeDescription) {
                return this.matcher.resolve(typeDescription);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.matcher.equals(((Entry)object).matcher)) {
                    return false;
                }
                if (!this.fieldAttributeAppenderFactory.equals(((Entry)object).fieldAttributeAppenderFactory)) {
                    return false;
                }
                if (!this.defaultValue.equals(((Entry)object).defaultValue)) {
                    return false;
                }
                return this.transformer.equals(((Entry)object).transformer);
            }

            public int hashCode() {
                return (((17 * 31 + this.matcher.hashCode()) * 31 + this.fieldAttributeAppenderFactory.hashCode()) * 31 + this.defaultValue.hashCode()) * 31 + this.transformer.hashCode();
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.FieldPool {

        public static enum NoOp implements Compiled
        {
            INSTANCE;


            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                return new TypeWriter.FieldPool.Record.ForImplicitField(fieldDescription);
            }
        }
    }
}

