/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import shadow.org.assertj.core.api.iterable.Extractor;
import shadow.org.assertj.core.groups.FieldsOrPropertiesExtractor;
import shadow.org.assertj.core.util.Closeables;
import shadow.org.assertj.core.util.Lists;

public final class Throwables {
    private static final String ORG_ASSERTJ_CORE_ERROR_CONSTRUCTOR_INVOKER = "shadow.org.assertj.core.error.ConstructorInvoker";
    private static final String JAVA_LANG_REFLECT_CONSTRUCTOR = "java.lang.reflect.Constructor";
    private static final String ORG_ASSERTJ = "org.assert";
    private static final Extractor<Throwable, String> ERROR_DESCRIPTION_EXTRACTOR = throwable -> {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable.getMessage();
        }
        String stackTraceDescription = Arrays.stream(cause.getStackTrace()).limit(5L).map(stackTraceElement -> String.format("\tat %s%n", stackTraceElement)).collect(Collectors.joining());
        return String.format("%s%ncause message: %s%ncause first five stack trace elements:%n%s", throwable.getMessage(), cause.getMessage(), stackTraceDescription);
    };

    public static List<String> describeErrors(List<Throwable> errors) {
        return FieldsOrPropertiesExtractor.extract(errors, ERROR_DESCRIPTION_EXTRACTOR);
    }

    public static void appendStackTraceInCurrentThreadToThrowable(Throwable t, String methodToStartFrom) {
        ArrayList<StackTraceElement> stackTrace = Lists.newArrayList(t.getStackTrace());
        stackTrace.addAll(Throwables.stackTraceInCurrentThread(methodToStartFrom));
        t.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    private static List<StackTraceElement> stackTraceInCurrentThread(String methodToStartFrom) {
        List<StackTraceElement> filtered = Throwables.stackTraceInCurrentThread();
        ArrayList<StackTraceElement> toRemove = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : filtered) {
            if (methodToStartFrom.equals(e.getMethodName())) break;
            toRemove.add(e);
        }
        filtered.removeAll(toRemove);
        return filtered;
    }

    private static List<StackTraceElement> stackTraceInCurrentThread() {
        return Lists.newArrayList(Thread.currentThread().getStackTrace());
    }

    public static void removeAssertJRelatedElementsFromStackTrace(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        ArrayList<StackTraceElement> filtered = Lists.newArrayList(throwable.getStackTrace());
        StackTraceElement previous = null;
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (element.getClassName().contains(ORG_ASSERTJ)) {
                filtered.remove(element);
                if (previous != null && JAVA_LANG_REFLECT_CONSTRUCTOR.equals(previous.getClassName()) && element.getClassName().contains(ORG_ASSERTJ_CORE_ERROR_CONSTRUCTOR_INVOKER)) {
                    filtered.remove(previous);
                }
            }
            previous = element;
        }
        StackTraceElement[] newStackTrace = filtered.toArray(new StackTraceElement[filtered.size()]);
        throwable.setStackTrace(newStackTrace);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        if (throwable.getCause() == null) {
            return null;
        }
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable throwable) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            string = sw.getBuffer().toString();
        }
        catch (Throwable throwable2) {
            Closeables.closeQuietly(sw, pw);
            throw throwable2;
        }
        Closeables.closeQuietly(sw, pw);
        return string;
    }

    private Throwables() {
    }
}

