/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotContext;
import au.com.origin.snapshots.SnapshotHeader;
import au.com.origin.snapshots.annotations.SnapshotName;
import java.lang.reflect.Method;

public class SnapshotSerializerContext {
    private String name;
    private String scenario;
    private SnapshotHeader header;
    private Class<?> testClass;
    private final Method testMethod;

    public static SnapshotSerializerContext from(SnapshotContext context) {
        SnapshotName snapshotName = context.getTestMethod().getAnnotation(SnapshotName.class);
        String name = snapshotName == null ? context.getTestClass().getName() + "." + context.getTestMethod().getName() : snapshotName.value();
        return new SnapshotSerializerContext(name, context.getScenario(), context.getHeader(), context.getTestClass(), context.getTestMethod());
    }

    public Snapshot toSnapshot(String body) {
        return Snapshot.builder().name(this.name).scenario(this.scenario).header(this.header).body(body).build();
    }

    public SnapshotSerializerContext(String name, String scenario, SnapshotHeader header, Class<?> testClass, Method testMethod) {
        this.name = name;
        this.scenario = scenario;
        this.header = header;
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public SnapshotHeader getHeader() {
        return this.header;
    }

    public void setHeader(SnapshotHeader header) {
        this.header = header;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }
}

