/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.groups;

import java.util.List;
import shadow.org.assertj.core.util.ArrayWrapperList;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.VisibleForTesting;
import shadow.org.assertj.core.util.introspection.PropertySupport;

public class Properties<T> {
    @VisibleForTesting
    final String propertyName;
    final Class<T> propertyType;
    @VisibleForTesting
    PropertySupport propertySupport = PropertySupport.instance();

    public static <T> Properties<T> extractProperty(String propertyName, Class<T> propertyType) {
        Properties.checkIsNotNullOrEmpty(propertyName);
        return new Properties<T>(propertyName, propertyType);
    }

    public static Properties<Object> extractProperty(String propertyName) {
        return Properties.extractProperty(propertyName, Object.class);
    }

    private static void checkIsNotNullOrEmpty(String propertyName) {
        Preconditions.checkNotNull(propertyName, "The name of the property to read should not be null");
        Preconditions.checkArgument(propertyName.length() > 0, "The name of the property to read should not be empty", new Object[0]);
    }

    @VisibleForTesting
    Properties(String propertyName, Class<T> propertyType) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public <U> Properties<U> ofType(Class<U> propertyType) {
        return Properties.extractProperty(this.propertyName, propertyType);
    }

    public List<T> from(Iterable<?> c) {
        return this.propertySupport.propertyValues(this.propertyName, this.propertyType, c);
    }

    public List<T> from(Object[] array) {
        return this.propertySupport.propertyValues(this.propertyName, this.propertyType, ArrayWrapperList.wrap(array));
    }
}

