/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.data.Offset;
import shadow.org.assertj.core.data.Percentage;
import shadow.org.assertj.core.error.ShouldHaveValue;
import shadow.org.assertj.core.error.ShouldNotContainValue;
import shadow.org.assertj.core.internal.Comparables;
import shadow.org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import shadow.org.assertj.core.internal.Longs;
import shadow.org.assertj.core.util.CheckReturnValue;
import shadow.org.assertj.core.util.VisibleForTesting;

public class AtomicLongAssert
extends AbstractAssert<AtomicLongAssert, AtomicLong> {
    @VisibleForTesting
    Comparables comparables = new Comparables();
    @VisibleForTesting
    Longs longs = Longs.instance();

    public AtomicLongAssert(AtomicLong actual) {
        super(actual, AtomicLongAssert.class);
    }

    public AtomicLongAssert hasValueBetween(long startInclusive, long endInclusive) {
        this.isNotNull();
        this.longs.assertIsBetween(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), startInclusive, endInclusive);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValueLessThan(long other) {
        this.isNotNull();
        this.longs.assertLessThan(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), other);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValueLessThanOrEqualTo(long other) {
        this.isNotNull();
        this.longs.assertLessThanOrEqualTo(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), other);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValueGreaterThan(long other) {
        this.isNotNull();
        this.longs.assertGreaterThan(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), other);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValueGreaterThanOrEqualTo(long other) {
        this.isNotNull();
        this.longs.assertGreaterThanOrEqualTo(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), other);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasPositiveValue() {
        this.isNotNull();
        this.longs.assertIsPositive(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get());
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasNonPositiveValue() {
        this.isNotNull();
        this.longs.assertIsNotPositive(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get());
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasNegativeValue() {
        this.isNotNull();
        this.longs.assertIsNegative(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get());
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasNonNegativeValue() {
        this.isNotNull();
        this.longs.assertIsNotNegative(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get());
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValueCloseTo(long expected, Percentage percentage) {
        this.isNotNull();
        this.longs.assertIsCloseToPercentage(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), expected, percentage);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValueCloseTo(long expected, Offset<Long> offset) {
        this.isNotNull();
        this.longs.assertIsCloseTo(this.getWritableAssertionInfo(), ((AtomicLong)this.actual).get(), expected, offset);
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert hasValue(long expectedValue) {
        this.isNotNull();
        long actualValue = ((AtomicLong)this.actual).get();
        if (!this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldHaveValue.shouldHaveValue(this.actual, expectedValue));
        }
        return (AtomicLongAssert)this.myself;
    }

    public AtomicLongAssert doesNotHaveValue(long expectedValue) {
        this.isNotNull();
        long actualValue = ((AtomicLong)this.actual).get();
        if (this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldNotContainValue.shouldNotContainValue(this.actual, expectedValue));
        }
        return (AtomicLongAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicLongAssert usingComparator(Comparator<? super AtomicLong> customComparator) {
        return this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public AtomicLongAssert usingComparator(Comparator<? super AtomicLong> customComparator, String customComparatorDescription) {
        this.longs = new Longs(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (AtomicLongAssert)super.usingComparator(customComparator, customComparatorDescription);
    }

    @Override
    @CheckReturnValue
    public AtomicLongAssert usingDefaultComparator() {
        this.longs = Longs.instance();
        return (AtomicLongAssert)super.usingDefaultComparator();
    }
}

