/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import java.io.File;
import java.nio.file.Path;
import shadow.org.assertj.core.error.BasicErrorMessageFactory;
import shadow.org.assertj.core.error.ErrorMessageFactory;
import shadow.org.assertj.core.util.VisibleForTesting;

public class ShouldNotExist
extends BasicErrorMessageFactory {
    @VisibleForTesting
    public static final String PATH_SHOULD_NOT_EXIST = "%nExpecting path:%n  <%s>%nnot to exist";
    @VisibleForTesting
    public static final String FILE_SHOULD_NOT_EXIST = "%nExpecting file:%n  <%s>%nnot to exist";
    @VisibleForTesting
    public static final String PATH_SHOULD_NOT_EXIST_NO_FOLLOW_LINKS = "%nExpecting path:%n  <%s>%nnot to exist (symbolic links were not followed).";

    public static ErrorMessageFactory shouldNotExist(File actual) {
        return new ShouldNotExist(actual);
    }

    public static ErrorMessageFactory shouldNotExist(Path actual) {
        return new ShouldNotExist(actual);
    }

    public static ErrorMessageFactory shouldExistNoFollowLinks(Path actual) {
        return new ShouldNotExist(actual);
    }

    private ShouldNotExist(File actual) {
        super(FILE_SHOULD_NOT_EXIST, actual);
    }

    private ShouldNotExist(Path actual) {
        super(PATH_SHOULD_NOT_EXIST, actual);
    }

    private ShouldNotExist(Path actual, boolean followLinks) {
        super(followLinks ? PATH_SHOULD_NOT_EXIST : PATH_SHOULD_NOT_EXIST_NO_FOLLOW_LINKS, actual);
    }
}

