/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import java.util.Objects;
import java.util.function.Predicate;
import shadow.org.assertj.core.error.BasicErrorMessageFactory;
import shadow.org.assertj.core.error.ErrorMessageFactory;
import shadow.org.assertj.core.presentation.PredicateDescription;

public class ShouldNotMatch
extends BasicErrorMessageFactory {
    public static final String ADVICE = String.format("%n%nYou can use 'doesNotMatch(Predicate p, String description)' to have a better error message%nFor example:%n  assertThat(player).doesNotMatch(p -> p.isRookie(), \"is not rookie\");%nwill give an error message looking like:%n%nExpecting:%n  <player>%nnot to match 'is not rookie' predicate", new Object[0]);

    public static <T> ErrorMessageFactory shouldNotMatch(T actual, Predicate<? super T> predicate, PredicateDescription predicateDescription) {
        Objects.requireNonNull(predicateDescription, "The predicate description must not be null");
        return new ShouldNotMatch(actual, predicate, predicateDescription);
    }

    private ShouldNotMatch(Object actual, Predicate<?> predicate, PredicateDescription description) {
        super("%nExpecting:%n  <%s>%nnot to match %s predicate." + (description.isDefault() ? ADVICE : ""), actual, description);
    }
}

