/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import java.math.BigDecimal;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.Numbers;
import shadow.org.assertj.core.util.VisibleForTesting;

public class BigDecimals
extends Numbers<BigDecimal> {
    private static final BigDecimals INSTANCE = new BigDecimals();

    public static BigDecimals instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    BigDecimals() {
    }

    public BigDecimals(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected BigDecimal zero() {
        return BigDecimal.ZERO;
    }

    @Override
    protected BigDecimal one() {
        return BigDecimal.ONE;
    }

    @Override
    protected BigDecimal absDiff(BigDecimal actual, BigDecimal other) {
        return actual.subtract(other).abs();
    }

    @Override
    protected boolean isGreaterThan(BigDecimal value, BigDecimal other) {
        return value.subtract(other).compareTo(BigDecimal.ZERO) > 0;
    }

    @Override
    protected boolean areEqual(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.compareTo(value2) == 0;
    }
}

