/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.error.ShouldBeLowerCase;
import shadow.org.assertj.core.error.ShouldBeUpperCase;
import shadow.org.assertj.core.internal.Comparables;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.util.VisibleForTesting;

public class Characters
extends Comparables {
    private static final Characters INSTANCE = new Characters();

    public static Characters instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Characters() {
    }

    public Characters(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    public void assertLowerCase(AssertionInfo info, Character actual) {
        Characters.assertNotNull(info, actual);
        if (Character.isLowerCase(actual.charValue())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLowerCase.shouldBeLowerCase(actual));
    }

    public void assertUpperCase(AssertionInfo info, Character actual) {
        Characters.assertNotNull(info, actual);
        if (Character.isUpperCase(actual.charValue())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeUpperCase.shouldBeUpperCase(actual));
    }
}

