/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.error.ShouldBeAbsolutePath;
import shadow.org.assertj.core.error.ShouldBeDirectory;
import shadow.org.assertj.core.error.ShouldBeFile;
import shadow.org.assertj.core.error.ShouldBeReadable;
import shadow.org.assertj.core.error.ShouldBeRelativePath;
import shadow.org.assertj.core.error.ShouldBeWritable;
import shadow.org.assertj.core.error.ShouldExist;
import shadow.org.assertj.core.error.ShouldHaveBinaryContent;
import shadow.org.assertj.core.error.ShouldHaveContent;
import shadow.org.assertj.core.error.ShouldHaveDigest;
import shadow.org.assertj.core.error.ShouldHaveExtension;
import shadow.org.assertj.core.error.ShouldHaveName;
import shadow.org.assertj.core.error.ShouldHaveNoParent;
import shadow.org.assertj.core.error.ShouldHaveParent;
import shadow.org.assertj.core.error.ShouldHaveSameContent;
import shadow.org.assertj.core.error.ShouldNotExist;
import shadow.org.assertj.core.internal.BinaryDiff;
import shadow.org.assertj.core.internal.BinaryDiffResult;
import shadow.org.assertj.core.internal.Diff;
import shadow.org.assertj.core.internal.DigestDiff;
import shadow.org.assertj.core.internal.Digests;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.internal.NioFilesWrapper;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.VisibleForTesting;
import shadow.org.assertj.core.util.diff.Delta;

public class Files {
    private static final String UNABLE_TO_COMPARE_FILE_CONTENTS = "Unable to compare contents of files:<%s> and:<%s>";
    private static final Files INSTANCE = new Files();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    NioFilesWrapper nioFilesWrapper = NioFilesWrapper.instance();

    public static Files instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Files() {
    }

    public void assertSameContentAs(AssertionInfo info, File actual, Charset actualCharset, File expected, Charset expectedCharset) {
        this.verifyIsFile(expected);
        this.assertIsFile(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (MalformedInputException e) {
            try {
                BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected.toPath()));
                if (binaryDiffResult.hasNoDiff()) {
                    throw e;
                }
                throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), ioe);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info, File actual, byte[] expected) {
        Preconditions.checkNotNull(expected, "The binary content to compare to should not be null");
        this.assertIsFile(info, actual);
        try {
            BinaryDiffResult result = this.binaryDiff.diff(actual, expected);
            if (result.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, result));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify binary contents of file:<%s>", actual);
            throw new UncheckedIOException(msg, e);
        }
    }

    public void assertHasContent(AssertionInfo info, File actual, String expected, Charset charset) {
        Preconditions.checkNotNull(expected, "The text to compare to should not be null");
        this.assertIsFile(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify text contents of file:<%s>", actual);
            throw new UncheckedIOException(msg, e);
        }
    }

    private void verifyIsFile(File expected) {
        Preconditions.checkNotNull(expected, "The file to compare to should not be null");
        Preconditions.checkArgument(expected.isFile(), "Expected file:<'%s'> should be an existing file", expected);
    }

    public void assertIsFile(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.isFile()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeFile.shouldBeFile(actual));
    }

    public void assertIsDirectory(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.isDirectory()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeDirectory.shouldBeDirectory(actual));
    }

    public void assertIsAbsolute(AssertionInfo info, File actual) {
        if (this.isAbsolutePath(info, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
    }

    public void assertIsRelative(AssertionInfo info, File actual) {
        if (!this.isAbsolutePath(info, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeRelativePath.shouldBeRelativePath(actual));
    }

    private boolean isAbsolutePath(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        return actual.isAbsolute();
    }

    public void assertExists(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.exists()) {
            return;
        }
        throw this.failures.failure(info, ShouldExist.shouldExist(actual));
    }

    public void assertDoesNotExist(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (!actual.exists()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotExist.shouldNotExist(actual));
    }

    public void assertCanWrite(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canWrite()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWritable.shouldBeWritable(actual));
    }

    public void assertCanRead(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canRead()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeReadable.shouldBeReadable(actual));
    }

    public void assertHasParent(AssertionInfo info, File actual, File expected) {
        Preconditions.checkNotNull(expected, "The expected parent file should not be null.");
        Files.assertNotNull(info, actual);
        try {
            if (actual.getParentFile() != null && shadow.org.assertj.core.util.Objects.areEqual(expected.getCanonicalFile(), actual.getParentFile().getCanonicalFile())) {
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to get canonical form of [%s] or [%s].", actual, expected), e);
        }
        throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, expected));
    }

    public void assertHasExtension(AssertionInfo info, File actual, String expected) {
        Preconditions.checkNotNull(expected, "The expected extension should not be null.");
        this.assertIsFile(info, actual);
        String actualExtension = this.getFileExtension(actual);
        if (expected.equals(actualExtension)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveExtension.shouldHaveExtension(actual, actualExtension, expected));
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int dotAt = name.lastIndexOf(46);
        return dotAt == -1 ? null : name.substring(dotAt + 1);
    }

    public void assertHasName(AssertionInfo info, File actual, String expected) {
        Files.assertNotNull(info, actual);
        Preconditions.checkNotNull(expected, "The expected name should not be null.");
        if (expected.equals(actual.getName())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveName.shouldHaveName(actual, expected));
    }

    private static void assertNotNull(AssertionInfo info, File actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public void assertHasNoParent(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.getParentFile() == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoParent.shouldHaveNoParent(actual));
    }

    public void assertHasDigest(AssertionInfo info, File actual, MessageDigest digest, byte[] expected) {
        Preconditions.checkNotNull(digest, "The message digest algorithm should not be null");
        Preconditions.checkNotNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertExists(info, actual);
        this.assertIsFile(info, actual);
        this.assertCanRead(info, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual.toPath(), new OpenOption[0]);){
            DigestDiff digestDiff = Digests.digestDiff(actualStream, digest, expected);
            if (digestDiff.digestsDiffer()) {
                throw this.failures.failure(info, ShouldHaveDigest.shouldHaveDigest(actual, digestDiff));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to calculate digest of path:<%s>", actual), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, File actual, MessageDigest digest, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info, File actual, String algorithm, byte[] expected) {
        Preconditions.checkNotNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, File actual, String algorithm, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, algorithm, Digests.fromHex(expected));
    }
}

