/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.api.Condition;
import shadow.org.assertj.core.data.Index;
import shadow.org.assertj.core.error.ShouldBeAtIndex;
import shadow.org.assertj.core.error.ShouldBeSorted;
import shadow.org.assertj.core.error.ShouldContainAtIndex;
import shadow.org.assertj.core.error.ShouldHaveAtIndex;
import shadow.org.assertj.core.error.ShouldNotContainAtIndex;
import shadow.org.assertj.core.internal.CommonValidations;
import shadow.org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.Conditions;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.internal.Iterables;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.internal.StandardComparisonStrategy;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.VisibleForTesting;

public class Lists {
    private static final Lists INSTANCE = new Lists();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Lists instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Lists() {
        this(StandardComparisonStrategy.instance());
    }

    public Lists(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertContains(AssertionInfo info, List<?> actual, Object value, Index index) {
        this.assertNotNull(info, actual);
        Iterables.instance().assertNotEmpty(info, actual);
        CommonValidations.checkIndexValueIsValid(index, actual.size() - 1);
        Object actualElement = actual.get(index.value);
        if (this.areEqual(actualElement, value)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainAtIndex.shouldContainAtIndex(actual, value, index, actual.get(index.value), this.comparisonStrategy));
    }

    public void assertDoesNotContain(AssertionInfo info, List<?> actual, Object value, Index index) {
        this.assertNotNull(info, actual);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        int indexValue = index.value;
        if (indexValue >= actual.size()) {
            return;
        }
        Object actualElement = actual.get(index.value);
        if (!this.areEqual(actualElement, value)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainAtIndex.shouldNotContainAtIndex(actual, value, index, this.comparisonStrategy));
    }

    public void assertIsSorted(AssertionInfo info, List<?> actual) {
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator<?> comparator = ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
            this.assertIsSortedAccordingToComparator(info, actual, comparator);
            return;
        }
        try {
            List<Comparable<Object>> comparableList = Lists.listOfComparableElements(actual);
            if (comparableList.size() <= 1) {
                return;
            }
            for (int i = 0; i < comparableList.size() - 1; ++i) {
                if (comparableList.get(i).compareTo(comparableList.get(i + 1)) <= 0) continue;
                throw this.failures.failure(info, ShouldBeSorted.shouldBeSorted(i, actual));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ShouldBeSorted.shouldHaveMutuallyComparableElements(actual));
        }
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, List<?> actual, Comparator<?> comparator) {
        this.assertNotNull(info, actual);
        Preconditions.checkNotNull(comparator, "The given comparator should not be null");
        try {
            if (actual.size() == 0) {
                return;
            }
            Comparator<?> rawComparator = comparator;
            if (actual.size() == 1) {
                rawComparator.compare(actual.get(0), actual.get(0));
                return;
            }
            for (int i = 0; i < actual.size() - 1; ++i) {
                if (rawComparator.compare(actual.get(i), actual.get(i + 1)) <= 0) continue;
                throw this.failures.failure(info, ShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i, actual, comparator));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator(actual, comparator));
        }
    }

    public <T> void assertHas(AssertionInfo info, List<? extends T> actual, Condition<? super T> condition, Index index) {
        if (this.conditionIsMetAtIndex(info, actual, condition, index)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveAtIndex.shouldHaveAtIndex(actual, condition, index, actual.get(index.value)));
    }

    public <T> void assertIs(AssertionInfo info, List<? extends T> actual, Condition<? super T> condition, Index index) {
        if (this.conditionIsMetAtIndex(info, actual, condition, index)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAtIndex.shouldBeAtIndex(actual, condition, index, actual.get(index.value)));
    }

    public <T> void satisfies(AssertionInfo info, List<? extends T> actual, Consumer<? super T> requirements, Index index) {
        this.assertNotNull(info, actual);
        Preconditions.checkNotNull(requirements, "The Consumer expressing the assertions requirements must not be null");
        CommonValidations.checkIndexValueIsValid(index, actual.size() - 1);
        requirements.accept(actual.get(index.value));
    }

    private <T> boolean conditionIsMetAtIndex(AssertionInfo info, List<T> actual, Condition<? super T> condition, Index index) {
        this.assertNotNull(info, actual);
        this.assertNotNull(condition);
        Iterables.instance().assertNotEmpty(info, actual);
        CommonValidations.checkIndexValueIsValid(index, actual.size() - 1);
        return condition.matches(actual.get(index.value));
    }

    private static List<Comparable<Object>> listOfComparableElements(List<?> collection) {
        return collection.stream().map(object -> (Comparable)object).collect(Collectors.toList());
    }

    private void assertNotNull(AssertionInfo info, List<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private void assertNotNull(Condition<?> condition) {
        Conditions.instance().assertIsNotNull(condition);
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }
}

