/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal.bytebuddy.implementation.bytecode.constant;

import shadow.org.assertj.core.internal.bytebuddy.ClassFileVersion;
import shadow.org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import shadow.org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import shadow.org.assertj.core.internal.bytebuddy.implementation.Implementation;
import shadow.org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import shadow.org.assertj.core.internal.bytebuddy.implementation.bytecode.StackSize;
import shadow.org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;
import shadow.org.assertj.core.internal.bytebuddy.jar.asm.Type;

public enum ClassConstant implements StackManipulation
{
    VOID(Void.class),
    BOOLEAN(Boolean.class),
    BYTE(Byte.class),
    SHORT(Short.class),
    CHARACTER(Character.class),
    INTEGER(Integer.class),
    LONG(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class);

    private static final StackManipulation.Size SIZE;
    private static final String PRIMITIVE_TYPE_FIELD = "TYPE";
    private static final String CLASS_TYPE_INTERNAL_NAME = "Ljava/lang/Class;";
    private final String fieldOwnerInternalName;

    private ClassConstant(Class<?> type) {
        this.fieldOwnerInternalName = Type.getInternalName(type);
    }

    public static StackManipulation of(TypeDescription typeDescription) {
        if (typeDescription.isPrimitive()) {
            if (typeDescription.represents(Void.TYPE)) {
                return VOID;
            }
            if (typeDescription.represents(Boolean.TYPE)) {
                return BOOLEAN;
            }
            if (typeDescription.represents(Byte.TYPE)) {
                return BYTE;
            }
            if (typeDescription.represents(Short.TYPE)) {
                return SHORT;
            }
            if (typeDescription.represents(Character.TYPE)) {
                return CHARACTER;
            }
            if (typeDescription.represents(Integer.TYPE)) {
                return INTEGER;
            }
            if (typeDescription.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDescription.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDescription.represents(Double.TYPE)) {
                return DOUBLE;
            }
        }
        return new ForReferenceType(typeDescription);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitFieldInsn(178, this.fieldOwnerInternalName, PRIMITIVE_TYPE_FIELD, CLASS_TYPE_INTERNAL_NAME);
        return SIZE;
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForReferenceType
    implements StackManipulation {
        private final TypeDescription typeDescription;

        protected ForReferenceType(TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            if (implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V5) && this.typeDescription.isVisibleTo(implementationContext.getInstrumentedType())) {
                methodVisitor.visitLdcInsn(Type.getType(this.typeDescription.getDescriptor()));
            } else {
                methodVisitor.visitLdcInsn(this.typeDescription.getName());
                methodVisitor.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            }
            return SIZE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.typeDescription.equals(((ForReferenceType)object).typeDescription);
        }

        public int hashCode() {
            return 17 * 31 + this.typeDescription.hashCode();
        }
    }
}

