/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.time.LocalDateTime;
import java.util.Arrays;
import shadow.org.assertj.core.api.AbstractTemporalAssert;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.error.ShouldBeAfter;
import shadow.org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import shadow.org.assertj.core.error.ShouldBeBefore;
import shadow.org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import shadow.org.assertj.core.error.ShouldBeEqualIgnoringHours;
import shadow.org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import shadow.org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import shadow.org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.util.Preconditions;

public abstract class AbstractLocalDateTimeAssert<SELF extends AbstractLocalDateTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, LocalDateTime> {
    public static final String NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE = "The LocalDateTime to compare actual with should not be null";

    protected AbstractLocalDateTimeAssert(LocalDateTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!((LocalDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBefore(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBefore(this.parse(localDateTimeAsString));
    }

    public SELF isBeforeOrEqualTo(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (((LocalDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(localDateTimeAsString));
    }

    public SELF isAfterOrEqualTo(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (((LocalDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfterOrEqualTo(this.parse(localDateTimeAsString));
    }

    public SELF isAfter(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!((LocalDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isAfter(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfter(this.parse(localDateTimeAsString));
    }

    public SELF isEqualTo(String dateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)((AbstractLocalDateTimeAssert)this.isEqualTo(this.parse(dateTimeAsString)));
    }

    public SELF isNotEqualTo(String dateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)((AbstractLocalDateTimeAssert)this.isNotEqualTo(this.parse(dateTimeAsString)));
    }

    public SELF isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (SELF)((AbstractLocalDateTimeAssert)this.isIn(AbstractLocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString)));
    }

    public SELF isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (SELF)((AbstractLocalDateTimeAssert)this.isNotIn(AbstractLocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString)));
    }

    private static Object[] convertToLocalDateTimeArray(String ... dateTimesAsString) {
        return Arrays.stream(dateTimesAsString).map(LocalDateTime::parse).toArray();
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given LocalDateTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given LocalDateTime array should not be empty", new Object[0]);
    }

    private static void assertLocalDateTimeAsStringParameterIsNotNull(String localDateTimeAsString) {
        Preconditions.checkArgument(localDateTimeAsString != null, "The String representing the LocalDateTime to compare actual with should not be null", new Object[0]);
    }

    private static void assertLocalDateTimeParameterIsNotNull(LocalDateTime other) {
        Preconditions.checkArgument(other != null, NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE, new Object[0]);
    }

    public SELF isEqualToIgnoringNanos(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringNanos((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringSeconds(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringSeconds((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringMinutes(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringMinutes((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringHours(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.haveSameYearMonthAndDayOfMonth((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBetween(LocalDateTime startInclusive, LocalDateTime endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(LocalDateTime startExclusive, LocalDateTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    @Override
    protected LocalDateTime parse(String localDateTimeAsString) {
        return LocalDateTime.parse(localDateTimeAsString);
    }

    private static boolean areEqualIgnoringNanos(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(LocalDateTime actual, LocalDateTime other) {
        return actual.getYear() == other.getYear();
    }
}

