/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.error.ShouldHaveDigest;
import shadow.org.assertj.core.error.ShouldHaveSameContent;
import shadow.org.assertj.core.internal.Diff;
import shadow.org.assertj.core.internal.DigestDiff;
import shadow.org.assertj.core.internal.Digests;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.internal.InputStreamsException;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.VisibleForTesting;
import shadow.org.assertj.core.util.diff.Delta;

public class InputStreams {
    private static final InputStreams INSTANCE = new InputStreams();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static InputStreams instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    InputStreams() {
    }

    public void assertSameContentAs(AssertionInfo info, InputStream actual, InputStream expected) {
        Preconditions.checkNotNull(expected, "The InputStream to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of InputStreams:%n  <%s>%nand:%n  <%s>", actual, expected);
            throw new InputStreamsException(msg, e);
        }
    }

    public void assertHasContent(AssertionInfo info, InputStream actual, String expected) {
        Preconditions.checkNotNull(expected, "The String to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of InputStream:%n  <%s>%nand String:%n  <%s>", actual, expected);
            throw new InputStreamsException(msg, e);
        }
    }

    private static void assertNotNull(AssertionInfo info, InputStream stream) {
        Objects.instance().assertNotNull(info, stream);
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, MessageDigest digest, byte[] expected) {
        Preconditions.checkNotNull(digest, "The message digest algorithm should not be null");
        Preconditions.checkNotNull(expected, "The binary representation of digest to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            DigestDiff diff = Digests.digestDiff(actual, digest, expected);
            if (diff.digestsDiffer()) {
                throw this.failures.failure(info, ShouldHaveDigest.shouldHaveDigest(actual, diff));
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to calculate digest of InputStream:%n  <%s>", actual);
            throw new InputStreamsException(msg, e);
        }
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, MessageDigest digest, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, String algorithm, byte[] expected) {
        Preconditions.checkNotNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, String algorithm, String expected) {
        Preconditions.checkNotNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, algorithm, Digests.fromHex(expected));
    }
}

