/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal.bytebuddy.description.type;

import java.util.Collections;
import java.util.List;
import shadow.org.assertj.core.internal.bytebuddy.description.ByteCodeElement;
import shadow.org.assertj.core.internal.bytebuddy.description.annotation.AnnotationDescription;
import shadow.org.assertj.core.internal.bytebuddy.description.annotation.AnnotationList;
import shadow.org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import shadow.org.assertj.core.internal.bytebuddy.description.type.TypeList;
import shadow.org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

public class TypeVariableToken
implements ByteCodeElement.Token<TypeVariableToken> {
    private final String symbol;
    private final List<? extends TypeDescription.Generic> bounds;
    private final List<? extends AnnotationDescription> annotations;

    public TypeVariableToken(String symbol, List<? extends TypeDescription.Generic> bounds) {
        this(symbol, bounds, Collections.emptyList());
    }

    public TypeVariableToken(String symbol, List<? extends TypeDescription.Generic> bounds, List<? extends AnnotationDescription> annotations) {
        this.symbol = symbol;
        this.bounds = bounds;
        this.annotations = annotations;
    }

    public static TypeVariableToken of(TypeDescription.Generic typeVariable, ElementMatcher<? super TypeDescription> matcher) {
        return new TypeVariableToken(typeVariable.getSymbol(), typeVariable.getUpperBounds().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), typeVariable.getDeclaredAnnotations());
    }

    public String getSymbol() {
        return this.symbol;
    }

    public TypeList.Generic getBounds() {
        return new TypeList.Generic.Explicit(this.bounds);
    }

    public AnnotationList getAnnotations() {
        return new AnnotationList.Explicit(this.annotations);
    }

    @Override
    public TypeVariableToken accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
        return new TypeVariableToken(this.symbol, this.getBounds().accept(visitor), this.annotations);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeVariableToken)) {
            return false;
        }
        TypeVariableToken typeVariableToken = (TypeVariableToken)other;
        return this.symbol.equals(typeVariableToken.symbol) && this.bounds.equals(typeVariableToken.bounds) && this.annotations.equals(typeVariableToken.annotations);
    }

    public int hashCode() {
        int result = this.symbol.hashCode();
        result = 31 * result + this.bounds.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    public String toString() {
        return this.symbol;
    }
}

