/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import shadow.org.assertj.core.internal.bytebuddy.dynamic.loading.ClassInjector;
import shadow.org.assertj.core.internal.bytebuddy.dynamic.loading.ClassLoadingStrategy;

class ClassLoadingStrategyFactory {
    private static final MethodHandles.Lookup LOOKUP;
    private static final Method PRIVATE_LOOKUP_IN;

    ClassLoadingStrategyFactory() {
    }

    static ClassLoadingStrategy<ClassLoader> classLoadingStrategy(Class<?> assertClass) {
        if (ClassInjector.UsingReflection.isAvailable()) {
            return ClassLoadingStrategy.Default.INJECTION;
        }
        if (ClassInjector.UsingLookup.isAvailable()) {
            try {
                return ClassLoadingStrategy.UsingLookup.of(PRIVATE_LOOKUP_IN.invoke(null, assertClass, LOOKUP));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not access package of " + assertClass, e);
            }
        }
        throw new IllegalStateException("No code generation strategy available");
    }

    static {
        Method privateLookupIn;
        LOOKUP = MethodHandles.lookup();
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (Exception e) {
            privateLookupIn = null;
        }
        PRIVATE_LOOKUP_IN = privateLookupIn;
    }
}

