/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import shadow.org.assertj.core.description.Description;
import shadow.org.assertj.core.error.DescriptionFormatter;
import shadow.org.assertj.core.internal.AbstractComparisonStrategy;
import shadow.org.assertj.core.presentation.Representation;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.Strings;
import shadow.org.assertj.core.util.VisibleForTesting;

public class MessageFormatter {
    private static final MessageFormatter INSTANCE = new MessageFormatter();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static MessageFormatter instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    MessageFormatter() {
    }

    public String format(Description d, Representation p, String format, Object ... args) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(args);
        return this.descriptionFormatter.format(d) + Strings.formatIfArgs(format, this.format(p, args));
    }

    private Object[] format(Representation p, Object[] args) {
        int argCount = args.length;
        Object[] formatted = new String[argCount];
        for (int i = 0; i < argCount; ++i) {
            formatted[i] = this.asText(p, args[i]);
        }
        return formatted;
    }

    private String asText(Representation p, Object o) {
        if (o instanceof AbstractComparisonStrategy) {
            return ((AbstractComparisonStrategy)o).asText();
        }
        return p.toStringOf(o);
    }
}

