/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import shadow.org.assertj.core.error.BasicErrorMessageFactory;
import shadow.org.assertj.core.error.ErrorMessageFactory;

public class ShouldBeEqualWithTimePrecision
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeEqual(Date actual, Date expected, TimeUnit precision) {
        return new ShouldBeEqualWithTimePrecision(actual, expected, precision);
    }

    private ShouldBeEqualWithTimePrecision(Date actual, Date expected, TimeUnit precision) {
        super(ShouldBeEqualWithTimePrecision.buildErrorMessageTemplate(precision), actual, expected);
    }

    private static String buildErrorMessageTemplate(TimeUnit precision) {
        String fields = "";
        String lastField = "";
        if (precision.equals((Object)TimeUnit.HOURS)) {
            lastField = "day";
        } else if (precision.equals((Object)TimeUnit.MINUTES)) {
            fields = ", day";
            lastField = "hour";
        } else if (precision.equals((Object)TimeUnit.SECONDS)) {
            fields = ", day, hour";
            lastField = "minute";
        } else if (precision.equals((Object)TimeUnit.MILLISECONDS)) {
            fields = ", day, hour, minute";
            lastField = "second";
        }
        return "%nExpecting:%n  <%s>%nto have same year, month" + fields + " and " + lastField + " as:%n  <%s>%nbut had not.";
    }
}

