/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.extractor;

import java.util.Map;
import shadow.org.assertj.core.api.iterable.Extractor;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.VisibleForTesting;
import shadow.org.assertj.core.util.introspection.PropertyOrFieldSupport;

class ByNameSingleExtractor<T>
implements Extractor<T, Object> {
    private final String propertyOrFieldName;

    @VisibleForTesting
    ByNameSingleExtractor(String propertyOrFieldName) {
        this.propertyOrFieldName = propertyOrFieldName;
    }

    @Override
    public Object extract(T input) {
        Preconditions.checkArgument(this.propertyOrFieldName != null, "The name of the field/property to read should not be null", new Object[0]);
        Preconditions.checkArgument(this.propertyOrFieldName.length() > 0, "The name of the field/property to read should not be empty", new Object[0]);
        Preconditions.checkArgument(input != null, "The object to extract field/property from should not be null", new Object[0]);
        if (input instanceof Map) {
            Map map = (Map)input;
            return map.get(this.propertyOrFieldName);
        }
        return PropertyOrFieldSupport.EXTRACTION.getValueOf(this.propertyOrFieldName, input);
    }
}

