/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.jackson.serializers;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotSerializerContext;
import au.com.origin.snapshots.exceptions.SnapshotExtensionException;
import au.com.origin.snapshots.serializers.SerializerType;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import java.util.List;

public class JacksonSnapshotSerializer
implements SnapshotSerializer {
    private final PrettyPrinter pp = new DefaultPrettyPrinter(""){
        {
            DefaultIndenter lfOnlyIndenter = new DefaultIndenter("  ", "\n");
            this.indentArraysWith((DefaultPrettyPrinter.Indenter)lfOnlyIndenter);
            this.indentObjectsWith((DefaultPrettyPrinter.Indenter)lfOnlyIndenter);
        }

        public DefaultPrettyPrinter createInstance() {
            return new DefaultPrettyPrinter((DefaultPrettyPrinter)this);
        }

        public DefaultPrettyPrinter withSeparators(Separators separators) {
            this._separators = separators;
            this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
            return this;
        }
    };
    private final ObjectMapper objectMapper = new ObjectMapper(){
        {
            this.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            this.enable(SerializationFeature.WRITE_DATES_WITH_ZONE_ID);
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.findAndRegisterModules();
            this.setVisibility(this.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
            JacksonSnapshotSerializer.this.configure(this);
        }
    };

    public void configure(ObjectMapper objectMapper) {
    }

    public Snapshot apply(Object object, SnapshotSerializerContext gen) {
        try {
            List<Object> objects = Arrays.asList(object);
            String body = this.objectMapper.writer(this.pp).writeValueAsString(objects);
            return gen.toSnapshot(body);
        }
        catch (Exception e) {
            throw new SnapshotExtensionException("Jackson Serialization failed", (Throwable)e);
        }
    }

    public String getOutputFormat() {
        return SerializerType.JSON.name();
    }
}

