/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.action.comparator.impl;

import com.rainett.javagram.action.Action;
import com.rainett.javagram.action.comparator.ActionComparatorService;
import com.rainett.javagram.action.comparator.AnnotationComparator;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class ActionComparatorServiceImpl
implements ActionComparatorService {
    private final Map<Class<? extends Annotation>, AnnotationComparator<?>> annotationComparators;

    public ActionComparatorServiceImpl(List<AnnotationComparator<?>> comparatorsList) {
        Objects.requireNonNull(comparatorsList, "comparatorsList must not be null");
        this.annotationComparators = comparatorsList.stream().collect(Collectors.toMap(AnnotationComparator::getAnnotationType, Function.identity()));
    }

    @Override
    public <T extends Annotation> Comparator<Action> getActionComparator(Class<T> annotationType) {
        Objects.requireNonNull(annotationType, "annotationType must not be null");
        AnnotationComparator<T> annotationComparator = this.getComparatorOrThrow(annotationType);
        return ActionComparatorServiceImpl.createActionComparator(annotationType, annotationComparator);
    }

    private <T extends Annotation> AnnotationComparator<T> getComparatorOrThrow(Class<T> annotationType) {
        AnnotationComparator<?> comparator = this.annotationComparators.get(annotationType);
        if (comparator == null) {
            throw new NoSuchElementException(String.format("Action comparator not found for annotation type [%s]", annotationType));
        }
        return comparator;
    }

    private static <T extends Annotation> Comparator<Action> createActionComparator(Class<T> annotationClass, AnnotationComparator<T> annotationComparator) {
        return (action1, action2) -> {
            Object annotation1 = ActionComparatorServiceImpl.extractAnnotation(action1, annotationClass);
            Object annotation2 = ActionComparatorServiceImpl.extractAnnotation(action2, annotationClass);
            return annotationComparator.compare(annotation1, annotation2);
        };
    }

    private static <T extends Annotation> T extractAnnotation(Action action, Class<T> annotationClass) {
        Annotation annotation = AnnotationUtils.findAnnotation(action.getClass(), annotationClass);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Expected annotation [%s] not found on action class [%s].", annotationClass.getSimpleName(), action.getClass().getName()));
        }
        return (T)annotation;
    }
}

