/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.action.container.impl;

import com.rainett.javagram.action.Action;
import com.rainett.javagram.action.annotations.BotAction;
import com.rainett.javagram.action.comparator.ActionComparatorService;
import com.rainett.javagram.action.container.ActionCollector;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

@Service
public class ActionCollectorImpl
implements ActionCollector {
    private static final Logger log = LoggerFactory.getLogger(ActionCollectorImpl.class);
    private final ApplicationContext context;
    private final ActionComparatorService actionComparatorService;

    @Override
    public Map<Class<? extends Annotation>, List<Action>> collectActions() {
        Map<Class<? extends Annotation>, List<Action>> actions = this.context.getBeansWithAnnotation(BotAction.class).values().stream().filter(this::isAction).map(this::castToAction).collect(Collectors.groupingBy(this::extractAnnotationType));
        actions.forEach(this::sortActions);
        return actions;
    }

    private boolean isAction(Object object) {
        return object instanceof Action;
    }

    private Action castToAction(Object object) {
        return (Action)object;
    }

    private void sortActions(Class<? extends Annotation> annotationType, List<Action> actions) {
        Comparator<Action> comparator = this.actionComparatorService.getActionComparator(annotationType);
        actions.sort(comparator.reversed());
    }

    private Class<? extends Annotation> extractAnnotationType(Action action) {
        Objects.requireNonNull(action, "Action must not be null");
        for (Class<?> targetClass = action.getClass(); targetClass != null && targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Annotation annotation : targetClass.getAnnotations()) {
                if (AnnotationUtils.findAnnotation(annotation.annotationType(), BotAction.class) == null) continue;
                return annotation.annotationType();
            }
        }
        throw new IllegalStateException(String.format("Cannot find required annotation for action [%s].", action.getClass().getName()));
    }

    public ActionCollectorImpl(ApplicationContext context, ActionComparatorService actionComparatorService) {
        this.context = context;
        this.actionComparatorService = actionComparatorService;
    }
}

