/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.action.container.impl;

import com.rainett.javagram.action.Action;
import com.rainett.javagram.action.actionmatcher.ActionUpdateMatcher;
import com.rainett.javagram.action.container.ActionCollector;
import com.rainett.javagram.action.container.ActionContainer;
import com.rainett.javagram.action.updatematcher.UpdateTypeResolver;
import com.rainett.javagram.exceptions.ActionNotFoundException;
import com.rainett.javagram.exceptions.UnknownUpdateTypeException;
import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.telegram.telegrambots.meta.api.objects.Update;

@Service
public class ActionContainerImpl
implements ActionContainer {
    private static final Logger log = LoggerFactory.getLogger(ActionContainerImpl.class);
    private final ActionCollector actionCollector;
    private final List<UpdateTypeResolver<?>> updateTypeResolvers;
    private final Map<Class<? extends Annotation>, ActionUpdateMatcher<?>> actionMatchers;
    private Map<Class<? extends Annotation>, List<Action>> actions;

    public ActionContainerImpl(ActionCollector actionCollector, List<UpdateTypeResolver<?>> updateTypeResolvers, List<ActionUpdateMatcher<?>> actionUpdateMatchers) {
        this.actionCollector = actionCollector;
        this.updateTypeResolvers = updateTypeResolvers;
        this.actionMatchers = actionUpdateMatchers.stream().collect(Collectors.toMap(ActionUpdateMatcher::getAnnotationType, Function.identity()));
    }

    @Override
    public Action findByUpdate(Update update) {
        Class<? extends Annotation> annotationType = this.resolveUpdateType(update);
        List<Action> actionsByAnnotationType = this.actions.get(annotationType);
        return this.getMatchingAction(actionsByAnnotationType, update, annotationType);
    }

    @PostConstruct
    private void init() {
        this.actions = this.actionCollector.collectActions();
        log.info("Actions collected successfully: {}", this.actions);
    }

    private Class<? extends Annotation> resolveUpdateType(Update update) {
        return this.updateTypeResolvers.stream().filter(matcher -> matcher.test(update)).findFirst().orElseThrow(() -> new UnknownUpdateTypeException("Unknown update type: " + update)).getAnnotationType();
    }

    private Action getMatchingAction(List<Action> actionsByAnnotationType, Update update, Class<? extends Annotation> annotationType) {
        if (actionsByAnnotationType == null || actionsByAnnotationType.isEmpty()) {
            throw new ActionNotFoundException("No actions available for update: " + update);
        }
        ActionUpdateMatcher<?> matcher = this.actionMatchers.get(annotationType);
        if (matcher == null) {
            throw new IllegalStateException("No action matcher registered for annotation type: " + annotationType.getSimpleName());
        }
        return actionsByAnnotationType.stream().filter(action -> matcher.test(action, update)).findFirst().orElseThrow(() -> new ActionNotFoundException("No actions available for update: " + update));
    }
}

