/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.action.plugin.impl.command;

import com.rainett.javagram.action.actionmatcher.AbstractActionUpdateMatcher;
import com.rainett.javagram.action.annotations.Command;
import com.rainett.javagram.config.BotConfig;
import org.telegram.telegrambots.meta.api.objects.Update;

public class CommandUpdateMatcher
extends AbstractActionUpdateMatcher<Command> {
    private final BotConfig botConfig;

    @Override
    protected boolean match(Command annotation, Update update) {
        if (annotation.value().isEmpty()) {
            return true;
        }
        String expectedCommand = annotation.value().trim();
        String updateText = update.getMessage().getText();
        String extractedCommand = this.extractCommand(updateText);
        return expectedCommand.equals(extractedCommand);
    }

    @Override
    public Class<Command> getAnnotationType() {
        return Command.class;
    }

    private String extractCommand(String text) {
        String[] parts;
        String[] tokens = text.trim().split("\\s+");
        String commandToken = tokens[0];
        if (commandToken.contains("@") && (parts = commandToken.split("@", 2)).length == 2 && this.isBotUsername(parts)) {
            commandToken = parts[0];
        }
        return commandToken;
    }

    private boolean isBotUsername(String[] parts) {
        String username = this.botConfig.getUsername();
        if (username.startsWith("@")) {
            username = username.substring(1);
        }
        return parts[1].equalsIgnoreCase(username);
    }

    public CommandUpdateMatcher(BotConfig botConfig) {
        this.botConfig = botConfig;
    }
}

