/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.bot;

import com.rainett.javagram.config.BotConfig;
import com.rainett.javagram.update.service.UpdateService;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

public class LongPollingBot
extends TelegramLongPollingBot {
    private static final Logger log = LoggerFactory.getLogger(LongPollingBot.class);
    private final BotConfig botConfig;
    private final ObjectProvider<UpdateService> serviceProvider;

    public LongPollingBot(BotConfig botConfig, ObjectProvider<UpdateService> service) {
        super(botConfig.getToken());
        this.botConfig = botConfig;
        this.serviceProvider = service;
    }

    public void onUpdateReceived(Update update) {
        log.info("Received update: {}", (Object)update);
        UpdateService updateService = (UpdateService)this.serviceProvider.getIfAvailable();
        if (updateService == null) {
            String errorMessage = "UpdateService is not available";
            log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        updateService.handleUpdate(update);
    }

    public String getBotUsername() {
        return this.botConfig.getUsername();
    }

    @PostConstruct
    private void init() {
        try {
            TelegramBotsApi botsApi = new TelegramBotsApi(DefaultBotSession.class);
            botsApi.registerBot((org.telegram.telegrambots.meta.generics.LongPollingBot)this);
            log.info("LongPollingBot registered successfully with username: {}", (Object)this.getBotUsername());
        }
        catch (TelegramApiException e) {
            String errorMessage = "Failed to register bot with Telegram Bots API";
            log.error(errorMessage, (Throwable)e);
            throw new IllegalStateException(errorMessage, e);
        }
    }
}

