/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.config;

import com.rainett.javagram.bot.LongPollingBot;
import com.rainett.javagram.bot.WebhookBot;
import com.rainett.javagram.config.BotConfig;
import com.rainett.javagram.update.service.UpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

@Configuration
@ComponentScan(basePackages={"com.rainett.javagram"})
@EnableConfigurationProperties(value={BotConfig.class})
public class AutoConfig {
    private static final Logger log = LoggerFactory.getLogger(AutoConfig.class);

    @Bean
    @ConditionalOnProperty(name={"bot.path"})
    public DefaultAbsSender webhookBot(BotConfig botConfig) throws TelegramApiException {
        log.info("Webhook enabled (bot.path: {}), creating WebhookBot instance", (Object)botConfig.getPath());
        return new WebhookBot(new SetWebhook(botConfig.getPath()), botConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultAbsSender.class})
    public DefaultAbsSender longPollingBot(BotConfig botConfig, ObjectProvider<UpdateService> updateService) {
        log.info("Webhook disabled, creating LongPollingBot instance");
        return new LongPollingBot(botConfig, updateService);
    }
}

