/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.keyboard;

import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;

public class InlineKeyboardBuilder {
    private final List<List<InlineKeyboardButton>> keyboard = new ArrayList<List<InlineKeyboardButton>>();

    public RowBuilder row() {
        return new RowBuilder(this);
    }

    public InlineKeyboardMarkup build() {
        InlineKeyboardMarkup markup = new InlineKeyboardMarkup();
        markup.setKeyboard(this.keyboard);
        return markup;
    }

    private void addRow(List<InlineKeyboardButton> row) {
        this.keyboard.add(row);
    }

    public static class RowBuilder {
        private final InlineKeyboardBuilder parent;
        private final List<InlineKeyboardButton> row = new ArrayList<InlineKeyboardButton>();
        private static final String DELIMITER = ":";

        public RowBuilder(InlineKeyboardBuilder parent) {
            this.parent = parent;
        }

        public RowBuilder button(String text, String key, String data) {
            InlineKeyboardButton button = new InlineKeyboardButton();
            button.setText(text);
            button.setCallbackData(key + DELIMITER + data);
            this.row.add(button);
            return this;
        }

        public RowBuilder button(String text, String key) {
            InlineKeyboardButton button = new InlineKeyboardButton();
            button.setText(text);
            button.setCallbackData(key);
            this.row.add(button);
            return this;
        }

        public InlineKeyboardBuilder endRow() {
            this.parent.addRow(this.row);
            return this.parent;
        }
    }
}

