/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.update.controller;

import com.rainett.javagram.update.service.UpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.telegram.telegrambots.meta.api.objects.Update;

@RestController
@ConditionalOnProperty(name={"bot.path"})
@RequestMapping(value={"/"})
public class UpdateController {
    private static final Logger log = LoggerFactory.getLogger(UpdateController.class);
    private final UpdateService updateService;

    @PostMapping
    public ResponseEntity<Void> onUpdateReceived(@RequestBody Update update) {
        log.info("Received update: {}", (Object)update);
        try {
            this.updateService.handleUpdate(update);
            return ResponseEntity.accepted().build();
        }
        catch (Exception e) {
            log.error("Error processing update: {}", (Object)update, (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    public UpdateController(UpdateService updateService) {
        this.updateService = updateService;
    }
}

