/*
 * Decompiled with CFR 0.152.
 */
package com.rainett.javagram.update.service.impl;

import com.rainett.javagram.action.Action;
import com.rainett.javagram.action.container.ActionContainer;
import com.rainett.javagram.exceptions.ActionNotFoundException;
import com.rainett.javagram.exceptions.UnknownUpdateTypeException;
import com.rainett.javagram.update.service.UpdateService;
import com.rainett.javagram.update.service.impl.DefaultAction;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.telegram.telegrambots.meta.api.objects.Update;

@Service
public class UpdateServiceImpl
implements UpdateService {
    private static final Logger log = LoggerFactory.getLogger(UpdateServiceImpl.class);
    private final ActionContainer actionContainer;
    private final Optional<DefaultAction> defaultActionOptional;

    public UpdateServiceImpl(ActionContainer actionContainer, @Autowired(required=false) DefaultAction defaultAction) {
        this.actionContainer = actionContainer;
        this.defaultActionOptional = Optional.ofNullable(defaultAction);
    }

    @Override
    public void handleUpdate(Update update) {
        try {
            Action botAction = this.actionContainer.findByUpdate(update);
            log.debug("Executing action: {} for update: {}", (Object)botAction.getClass().getSimpleName(), (Object)update);
            botAction.run(update);
        }
        catch (ActionNotFoundException | UnknownUpdateTypeException e) {
            this.defaultActionOptional.ifPresentOrElse(action -> UpdateServiceImpl.executeDefaultAction(update, action), () -> log.warn(e.getMessage()));
        }
        catch (Exception e) {
            log.error("Error processing update: {}", (Object)update, (Object)e);
        }
    }

    private static void executeDefaultAction(Update update, DefaultAction action) {
        log.info("Executing default action for update: {}", (Object)update);
        action.run(update);
    }
}

