/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chunk
implements Element {
    public static final String OBJECT_REPLACEMENT_CHARACTER = "\ufffc";
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE = new Chunk("");
    protected StringBuilder content = null;
    protected Font font = null;
    protected Map<String, Object> attributes = null;
    public static final String SEPARATOR = "SEPARATOR";
    public static final String TAB = "TAB";
    public static final String HSCALE = "HSCALE";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String SKEW = "SKEW";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String TEXTRENDERMODE = "TEXTRENDERMODE";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String IMAGE = "IMAGE";
    public static final String ACTION = "ACTION";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";

    public Chunk() {
        this.content = new StringBuilder();
        this.font = new Font();
    }

    public Chunk(Chunk ck) {
        if (ck.content != null) {
            this.content = new StringBuilder(ck.content.toString());
        }
        if (ck.font != null) {
            this.font = new Font(ck.font);
        }
        if (ck.attributes != null) {
            this.attributes = new HashMap<String, Object>(ck.attributes);
        }
    }

    public Chunk(String content, Font font) {
        this.content = new StringBuilder(content);
        this.font = font;
    }

    public Chunk(String content) {
        this(content, new Font());
    }

    public Chunk(char c, Font font) {
        this.content = new StringBuilder();
        this.content.append(c);
        this.font = font;
    }

    public Chunk(char c) {
        this(c, new Font());
    }

    public Chunk(Image image, float offsetX, float offsetY) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        Image copyImage = Image.getInstance(image);
        this.setAttribute(IMAGE, new Object[]{copyImage, Float.valueOf(offsetX), Float.valueOf(offsetY), Boolean.FALSE});
    }

    public Chunk(Image image, float offsetX, float offsetY, boolean changeLeading) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.setAttribute(IMAGE, new Object[]{image, Float.valueOf(offsetX), Float.valueOf(offsetY), changeLeading});
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 10;
    }

    @Override
    public List<Element> getChunks() {
        ArrayList<Element> tmp = new ArrayList<Element>();
        tmp.add(this);
        return tmp;
    }

    public StringBuilder append(String string) {
        return this.content.append(string);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        return this.content.toString();
    }

    @Override
    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf(10) == -1 && this.attributes == null;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    private Chunk setAttribute(String name, Object obj) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, obj);
        return this;
    }

    public Chunk setHorizontalScaling(float scale) {
        return this.setAttribute(HSCALE, Float.valueOf(scale));
    }

    public float getHorizontalScaling() {
        if (this.attributes == null) {
            return 1.0f;
        }
        Float f = (Float)this.attributes.get(HSCALE);
        if (f == null) {
            return 1.0f;
        }
        return f.floatValue();
    }

    public Chunk setUnderline(float thickness, float yPosition) {
        return this.setUnderline(null, thickness, 0.0f, yPosition, 0.0f, 0);
    }

    public Chunk setUnderline(Color color, float thickness, float thicknessMul, float yPosition, float yPositionMul, int cap) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        Object[] obj = new Object[]{color, new float[]{thickness, thicknessMul, yPosition, yPositionMul, cap}};
        Object[][] unders = Utilities.addToArray((Object[][])this.attributes.get(UNDERLINE), obj);
        return this.setAttribute(UNDERLINE, unders);
    }

    public Chunk setTextRise(float rise) {
        return this.setAttribute(SUBSUPSCRIPT, Float.valueOf(rise));
    }

    public float getTextRise() {
        if (this.attributes != null && this.attributes.containsKey(SUBSUPSCRIPT)) {
            Float f = (Float)this.attributes.get(SUBSUPSCRIPT);
            return f.floatValue();
        }
        return 0.0f;
    }

    public Chunk setSkew(float alpha, float beta) {
        alpha = (float)Math.tan((double)alpha * Math.PI / 180.0);
        beta = (float)Math.tan((double)beta * Math.PI / 180.0);
        return this.setAttribute(SKEW, new float[]{alpha, beta});
    }

    public Chunk setBackground(Color color) {
        return this.setBackground(color, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Chunk setBackground(Color color, float extraLeft, float extraBottom, float extraRight, float extraTop) {
        return this.setAttribute(BACKGROUND, new Object[]{color, new float[]{extraLeft, extraBottom, extraRight, extraTop}});
    }

    public Chunk setTextRenderMode(int mode, float strokeWidth, Color strokeColor) {
        return this.setAttribute(TEXTRENDERMODE, new Object[]{mode, Float.valueOf(strokeWidth), strokeColor});
    }

    public Chunk setRemoteGoto(String filename, String name) {
        return this.setAttribute(REMOTEGOTO, new Object[]{filename, name});
    }

    public Chunk setRemoteGoto(String filename, int page) {
        return this.setAttribute(REMOTEGOTO, new Object[]{filename, page});
    }

    public Chunk setLocalGoto(String name) {
        return this.setAttribute(LOCALGOTO, name);
    }

    public Chunk setLocalDestination(String name) {
        return this.setAttribute(LOCALDESTINATION, name);
    }

    public Chunk setGenericTag(String text) {
        return this.setAttribute(GENERICTAG, text);
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] obj = (Object[])this.attributes.get(IMAGE);
        if (obj == null) {
            return null;
        }
        return (Image)obj[0];
    }

    public Chunk setAnchor(URL url) {
        return this.setAttribute(ACTION, url.toExternalForm());
    }

    public Chunk setAnchor(String url) {
        return this.setAttribute(ACTION, url);
    }

    public Chunk setNewPage() {
        return this.setAttribute(NEWPAGE, null);
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    static {
        NEXTPAGE.setNewPage();
    }
}

