/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import java.awt.Color;
import java.util.Objects;

public class Font {
    public static final int COURIER = 0;
    public static final int HELVETICA = 1;
    public static final int TIMES_ROMAN = 2;
    public static final int SYMBOL = 3;
    public static final int ZAPFDINGBATS = 4;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int BOLDITALIC = 3;
    public static final int UNDEFINED = -1;
    public static final int DEFAULTSIZE = 12;
    private int family;
    private float size;
    private int style;
    private Color color;

    public Font(Font other) {
        this.family = other.family;
        this.size = other.size;
        this.style = other.style;
        this.color = other.color;
    }

    public Font(int family, float size, int style, Color color) {
        this.family = family;
        this.size = size;
        this.style = style;
        this.color = color;
    }

    public Font(int family, float size, int style) {
        this(family, size, style, null);
    }

    public Font(int family, float size) {
        this(family, size, -1, null);
    }

    public Font(int family) {
        this(family, -1.0f, -1, null);
    }

    public Font() {
        this(-1, -1.0f, -1, null);
    }

    public boolean same(Font that) {
        if (this == that) {
            return true;
        }
        return this.family == that.family && this.size == that.size && this.style == that.style && Objects.equals(this.color, that.color);
    }

    public int getFamily() {
        return this.family;
    }

    public String getFamilyname() {
        switch (this.getFamily()) {
            case 0: {
                return "Courier";
            }
            case 1: {
                return "Helvetica";
            }
            case 2: {
                return "Times-Roman";
            }
            case 3: {
                return "Symbol";
            }
            case 4: {
                return "ZapfDingbats";
            }
        }
        return "unknown";
    }

    public void setFamily(String family) {
        this.family = Font.getFamilyIndex(family);
    }

    public static int getFamilyIndex(String family) {
        if (family.equalsIgnoreCase("Courier")) {
            return 0;
        }
        if (family.equalsIgnoreCase("Helvetica")) {
            return 1;
        }
        if (family.equalsIgnoreCase("Times-Roman")) {
            return 2;
        }
        if (family.equalsIgnoreCase("Symbol")) {
            return 3;
        }
        if (family.equalsIgnoreCase("ZapfDingbats")) {
            return 4;
        }
        return -1;
    }

    public float getSize() {
        return this.size;
    }

    public float getCalculatedSize() {
        float s = this.size;
        if (s == -1.0f) {
            s = 12.0f;
        }
        return s;
    }

    public float getCalculatedLeading(float linespacing) {
        return linespacing * this.getCalculatedSize();
    }

    public void setSize(float size) {
        this.size = size;
    }

    public int getStyle() {
        return this.style;
    }

    public int getCalculatedStyle() {
        int style = this.style;
        if (style == -1) {
            style = 0;
        }
        if (this.family == 3 || this.family == 4) {
            return style;
        }
        return style & 0xFFFFFFFC;
    }

    public boolean isBold() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 2) == 2;
    }

    public boolean isUnderlined() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 4) == 4;
    }

    public boolean isStrikethru() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 8) == 8;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setStyle(String style) {
        if (this.style == -1) {
            this.style = 0;
        }
        this.style |= Font.getStyleValue(style);
    }

    public static int getStyleValue(String style) {
        int s = 0;
        if (style.contains("bold")) {
            s |= 1;
        }
        if (style.contains("italic")) {
            s |= 2;
        }
        if (style.contains("oblique")) {
            s |= 2;
        }
        if (style.contains("underline")) {
            s |= 4;
        }
        if (style.contains("line-through")) {
            s |= 8;
        }
        return s;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int red, int green, int blue) {
        this.color = new Color(red, green, blue);
    }

    public boolean isStandardFont() {
        return this.family == -1 && this.size == -1.0f && this.style == -1 && this.color == null;
    }

    public Font difference(Font font) {
        Color dColor;
        if (font == null) {
            return this;
        }
        float dSize = font.size;
        if (dSize == -1.0f) {
            dSize = this.size;
        }
        int dStyle = -1;
        int style1 = this.style;
        int style2 = font.getStyle();
        if (style1 != -1 || style2 != -1) {
            if (style1 == -1) {
                style1 = 0;
            }
            if (style2 == -1) {
                style2 = 0;
            }
            dStyle = style1 | style2;
        }
        if ((dColor = font.color) == null) {
            dColor = this.color;
        }
        if (font.getFamily() != -1) {
            return new Font(font.family, dSize, dStyle, dColor);
        }
        return new Font(this.family, dSize, dStyle, dColor);
    }
}

