/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class Image
extends Rectangle {
    public static final int ORIGINAL_NONE = 0;
    public static final int ORIGINAL_JPEG = 1;
    public static final int ORIGINAL_PNG = 2;
    public static final int ORIGINAL_GIF = 3;
    public static final int ORIGINAL_BMP = 4;
    public static final int ORIGINAL_WMF = 6;
    private final URL url;
    private final int originalType;
    private final byte[] originalData;
    private int alignment = 0;
    private String alt;
    private float plainWidth;
    private float plainHeight;

    public Image(URL url, byte[] originalData, int width, int height, int originalType) {
        super(width, height);
        this.url = url;
        this.originalData = originalData;
        this.plainWidth = width;
        this.plainHeight = height;
        this.originalType = originalType;
    }

    private Image(URL url, byte[] originalData, ImageInfo info) {
        this(url, originalData, info.image.getWidth(), info.image.getHeight(), info.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageInfo readImage(Object input) throws IOException {
        try (ImageInputStream iis = ImageIO.createImageInputStream(input);){
            if (iis == null) {
                throw new IIOException("Can't create an ImageInputStream!");
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                BufferedImage bi;
                ImageReader reader = readers.next();
                ImageReadParam param = reader.getDefaultReadParam();
                reader.setInput(iis, true, true);
                try {
                    bi = reader.read(0, param);
                }
                finally {
                    reader.dispose();
                }
                String format = reader.getFormatName();
                int type = "gif".equalsIgnoreCase(format) ? 3 : ("JPEG".equalsIgnoreCase(format) ? 1 : ("png".equalsIgnoreCase(format) ? 2 : ("bmp".equalsIgnoreCase(format) ? 4 : 0)));
                ImageInfo imageInfo = new ImageInfo(bi, type);
                return imageInfo;
            }
            throw new IOException("Cannot detect image format");
        }
    }

    public static Image getInstance(URL url) throws IOException {
        ImageInfo info;
        try (InputStream is = url.openStream();){
            info = Image.readImage(is);
        }
        return new Image(url, null, info);
    }

    public static Image getInstance(String filename) throws IOException {
        Path path = Paths.get(filename, new String[0]);
        byte[] data = Files.readAllBytes(path);
        ImageInfo info = Image.readImage(new ByteArrayInputStream(data));
        return new Image(path.toUri().toURL(), data, info);
    }

    public static Image getInstance(byte[] imgb) throws IOException {
        ImageInfo info = Image.readImage(new ByteArrayInputStream(imgb));
        return new Image(null, imgb, info);
    }

    public Image(Image image) {
        super(image);
        this.url = image.url;
        this.originalType = image.originalType;
        this.originalData = image.originalData;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
    }

    public static Image getInstance(Image image) {
        if (image == null) {
            return null;
        }
        return new Image(image);
    }

    @Override
    public int type() {
        return 34;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public float getPlainWidth() {
        return this.plainWidth;
    }

    public float getPlainHeight() {
        return this.plainHeight;
    }

    public void scaleAbsolute(float newWidth, float newHeight) {
        this.plainWidth = newWidth;
        this.plainHeight = newHeight;
    }

    public void scaleAbsoluteWidth(float newWidth) {
        this.plainWidth = newWidth;
    }

    public void scaleAbsoluteHeight(float newHeight) {
        this.plainHeight = newHeight;
    }

    public void scalePercent(float percent) {
        this.scalePercent(percent, percent);
    }

    public void scalePercent(float percentX, float percentY) {
        this.plainWidth = this.getWidth() * percentX / 100.0f;
        this.plainHeight = this.getHeight() * percentY / 100.0f;
    }

    public void scaleToFit(float fitWidth, float fitHeight) {
        float percentX = fitWidth * 100.0f / this.getWidth();
        float percentY = fitHeight * 100.0f / this.getHeight();
        this.scalePercent(Math.min(percentX, percentY));
    }

    public int getOriginalType() {
        return this.originalType;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    private static final class ImageInfo {
        final BufferedImage image;
        final int type;

        ImageInfo(BufferedImage image, int type) {
            this.image = image;
            this.type = type;
        }
    }
}

