/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import java.util.Collections;
import java.util.List;

public class Meta
implements Element {
    private final int type;
    private final StringBuilder content;

    Meta(int type, String content) {
        this.type = type;
        this.content = new StringBuilder(content);
    }

    public Meta(String tag, String content) {
        this.type = Meta.getType(tag);
        this.content = new StringBuilder(content);
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public List<Element> getChunks() {
        return Collections.emptyList();
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    public StringBuilder append(String string) {
        return this.content.append(string);
    }

    public String getContent() {
        return this.content.toString();
    }

    public String getName() {
        switch (this.type) {
            case 2: {
                return "subject";
            }
            case 3: {
                return "keywords";
            }
            case 4: {
                return "author";
            }
            case 1: {
                return "title";
            }
            case 5: {
                return "producer";
            }
            case 6: {
                return "creationdate";
            }
        }
        return "unknown";
    }

    public static int getType(String tag) {
        if ("subject".equals(tag)) {
            return 2;
        }
        if ("keywords".equals(tag)) {
            return 3;
        }
        if ("author".equals(tag)) {
            return 4;
        }
        if ("title".equals(tag)) {
            return 1;
        }
        if ("producer".equals(tag)) {
            return 5;
        }
        if ("creationdate".equals(tag)) {
            return 6;
        }
        return 0;
    }
}

