/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.List;

public class SimpleCell
extends Rectangle
implements TextElementArray {
    public static final boolean ROW = true;
    public static final boolean CELL = false;
    private final List<Element> content = new ArrayList<Element>();
    private float width = 0.0f;
    private float widthpercentage = 0.0f;
    private float spacing_left = Float.NaN;
    private float spacing_right = Float.NaN;
    private float spacing_top = Float.NaN;
    private float spacing_bottom = Float.NaN;
    private float padding_left = Float.NaN;
    private float padding_right = Float.NaN;
    private float padding_top = Float.NaN;
    private float padding_bottom = Float.NaN;
    private int colspan = 1;
    private int horizontalAlignment = -1;
    private int verticalAlignment = -1;
    private boolean cellgroup;
    protected boolean useAscender = false;
    protected boolean useDescender = false;
    protected boolean useBorderPadding;

    public SimpleCell(boolean row) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.cellgroup = row;
        this.setBorder(15);
    }

    public void addElement(Element element) throws BadElementException {
        if (this.cellgroup) {
            if (element instanceof SimpleCell) {
                if (((SimpleCell)element).isCellgroup()) {
                    throw new BadElementException("You can't add one row to another row.");
                }
                this.content.add(element);
                return;
            }
            throw new BadElementException("You can only add cells to rows, no objects of type " + element.getClass().getName());
        }
        if (element.type() != 12 && element.type() != 11 && element.type() != 17 && element.type() != 10 && element.type() != 14 && element.type() != 50 && element.type() != 34) {
            throw new BadElementException("You can't add an element of type " + element.getClass().getName() + " to a SimpleCell.");
        }
        this.content.add(element);
    }

    public Cell createCell(SimpleCell rowAttributes) throws BadElementException {
        Cell cell = new Cell();
        cell.cloneNonPositionParameters(rowAttributes);
        cell.softCloneNonPositionParameters(this);
        cell.setColspan(this.colspan);
        cell.setHorizontalAlignment(this.horizontalAlignment);
        cell.setVerticalAlignment(this.verticalAlignment);
        cell.setUseAscender(this.useAscender);
        cell.setUseBorderPadding(this.useBorderPadding);
        cell.setUseDescender(this.useDescender);
        for (Element element : this.content) {
            cell.addElement(element);
        }
        return cell;
    }

    public void setPadding(float padding) {
        if (Float.isNaN(this.padding_right)) {
            this.setPadding_right(padding);
        }
        if (Float.isNaN(this.padding_left)) {
            this.setPadding_left(padding);
        }
        if (Float.isNaN(this.padding_top)) {
            this.setPadding_top(padding);
        }
        if (Float.isNaN(this.padding_bottom)) {
            this.setPadding_bottom(padding);
        }
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        if (colspan > 0) {
            this.colspan = colspan;
        }
    }

    public float getPadding_bottom() {
        return this.padding_bottom;
    }

    public void setPadding_bottom(float padding_bottom) {
        this.padding_bottom = padding_bottom;
    }

    public float getPadding_left() {
        return this.padding_left;
    }

    public void setPadding_left(float padding_left) {
        this.padding_left = padding_left;
    }

    public float getPadding_right() {
        return this.padding_right;
    }

    public void setPadding_right(float padding_right) {
        this.padding_right = padding_right;
    }

    public float getPadding_top() {
        return this.padding_top;
    }

    public void setPadding_top(float padding_top) {
        this.padding_top = padding_top;
    }

    public float getSpacing_left() {
        return this.spacing_left;
    }

    public float getSpacing_right() {
        return this.spacing_right;
    }

    public float getSpacing_top() {
        return this.spacing_top;
    }

    public float getSpacing_bottom() {
        return this.spacing_bottom;
    }

    public void setSpacing(float spacing) {
        this.spacing_left = spacing;
        this.spacing_right = spacing;
        this.spacing_top = spacing;
        this.spacing_bottom = spacing;
    }

    public void setSpacing_left(float spacing) {
        this.spacing_left = spacing;
    }

    public void setSpacing_right(float spacing) {
        this.spacing_right = spacing;
    }

    public void setSpacing_top(float spacing) {
        this.spacing_top = spacing;
    }

    public void setSpacing_bottom(float spacing) {
        this.spacing_bottom = spacing;
    }

    public boolean isCellgroup() {
        return this.cellgroup;
    }

    public void setCellgroup(boolean cellgroup) {
        this.cellgroup = cellgroup;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getWidthpercentage() {
        return this.widthpercentage;
    }

    public void setWidthpercentage(float widthpercentage) {
        this.widthpercentage = widthpercentage;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean useAscender) {
        this.useAscender = useAscender;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public void setUseBorderPadding(boolean useBorderPadding) {
        this.useBorderPadding = useBorderPadding;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseDescender(boolean useDescender) {
        this.useDescender = useDescender;
    }

    List<Element> getContent() {
        return this.content;
    }

    @Override
    public boolean add(Element o) {
        try {
            this.addElement(o);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (BadElementException e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public int type() {
        return 20;
    }
}

