/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleTable
extends Rectangle
implements TextElementArray {
    private final List<SimpleCell> content = new ArrayList<SimpleCell>();
    private float width = 0.0f;
    private float widthpercentage = 0.0f;
    private float cellspacing;
    private float cellpadding;
    private int alignment;

    public SimpleTable() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(2.0f);
    }

    public void addElement(SimpleCell element) throws BadElementException {
        if (!element.isCellgroup()) {
            throw new BadElementException("You can't add cells to a table directly, add them to a row first.");
        }
        this.content.add(element);
    }

    public Table createTable() throws BadElementException {
        int i;
        SimpleCell cell;
        if (this.content.isEmpty()) {
            throw new BadElementException("Trying to create a table without rows.");
        }
        SimpleCell row = this.content.get(0);
        int columns = 0;
        for (Element value : row.getContent()) {
            cell = (SimpleCell)value;
            columns += cell.getColspan();
        }
        float[] widths = new float[columns];
        float[] widthpercentages = new float[columns];
        Table table = new Table(columns);
        table.setAlignment(this.alignment);
        table.setSpacing(this.cellspacing);
        table.setPadding(this.cellpadding);
        table.cloneNonPositionParameters(this);
        Iterator<SimpleCell> iterator = this.content.iterator();
        while (iterator.hasNext()) {
            SimpleCell simpleCell;
            row = simpleCell = iterator.next();
            int pos = 0;
            for (Element element : row.getContent()) {
                cell = (SimpleCell)element;
                table.addCell(cell.createCell(row));
                if (cell.getColspan() == 1) {
                    if (cell.getWidth() > 0.0f) {
                        widths[pos] = cell.getWidth();
                    }
                    if (cell.getWidthpercentage() > 0.0f) {
                        widthpercentages[pos] = cell.getWidthpercentage();
                    }
                }
                pos += cell.getColspan();
            }
        }
        float sumWidths = 0.0f;
        for (i = 0; i < columns; ++i) {
            if (widths[i] == 0.0f) {
                sumWidths = 0.0f;
                break;
            }
            sumWidths += widths[i];
        }
        if (sumWidths > 0.0f) {
            table.setWidth(sumWidths);
            table.setLocked(true);
            table.setWidths(widths);
        } else {
            for (i = 0; i < columns; ++i) {
                if (widthpercentages[i] == 0.0f) {
                    sumWidths = 0.0f;
                    break;
                }
                sumWidths += widthpercentages[i];
            }
            if (sumWidths > 0.0f) {
                table.setWidths(widthpercentages);
            }
        }
        if (this.width > 0.0f) {
            table.setWidth(this.width);
            table.setLocked(true);
        } else if (this.widthpercentage > 0.0f) {
            table.setWidth(this.widthpercentage);
        }
        return table;
    }

    public float getCellpadding() {
        return this.cellpadding;
    }

    public void setCellpadding(float cellpadding) {
        this.cellpadding = cellpadding;
    }

    public float getCellspacing() {
        return this.cellspacing;
    }

    public void setCellspacing(float cellspacing) {
        this.cellspacing = cellspacing;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getWidthpercentage() {
        return this.widthpercentage;
    }

    public void setWidthpercentage(float widthpercentage) {
        this.widthpercentage = widthpercentage;
    }

    @Override
    public int type() {
        return 22;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public boolean add(Element o) {
        try {
            this.addElement((SimpleCell)o);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (BadElementException e) {
            throw new ExceptionConverter(e);
        }
    }
}

