/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.text.RtfNewPage;
import java.io.IOException;
import java.io.OutputStream;

public class RtfWriter2
extends DocWriter {
    private RtfDocument rtfDoc;

    protected RtfWriter2(Document doc, OutputStream os) {
        super(doc, os);
        doc.addDocListener(this);
        this.rtfDoc = new RtfDocument();
    }

    public static RtfWriter2 getInstance(Document doc, OutputStream os) {
        return new RtfWriter2(doc, os);
    }

    @Override
    public void setHeader(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setHeader(hf);
    }

    @Override
    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    @Override
    public void setFooter(HeaderFooter hf) {
        this.rtfDoc.getDocumentHeader().setFooter(hf);
    }

    @Override
    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    @Override
    public void setPageCount(int i) {
    }

    @Override
    public void resetPageCount() {
    }

    public void clearTextWrap() {
    }

    @Override
    public void open() {
        super.open();
        this.rtfDoc.open();
    }

    @Override
    public void close() {
        if (this.open) {
            try {
                this.rtfDoc.writeDocument(this.os);
                super.close();
                this.rtfDoc = new RtfDocument();
            }
            catch (IOException ex) {
                throw new ExceptionConverter(ex);
            }
        }
    }

    @Override
    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        RtfBasicElement[] rtfElements = this.rtfDoc.getMapper().mapElement(element);
        if (rtfElements.length != 0) {
            for (RtfBasicElement rtfElement : rtfElements) {
                if (rtfElement == null) continue;
                this.rtfDoc.add(rtfElement);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean newPage() {
        this.rtfDoc.add(new RtfNewPage(this.rtfDoc));
        return true;
    }

    @Override
    public boolean setMargins(float left, float right, float top, float bottom) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)left * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)right * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)top * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)bottom * 20.0));
        return true;
    }

    @Override
    public boolean setPageSize(Rectangle rect) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rect);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.rtfDoc.setAutogenerateTOCEntries(autogenerate);
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.rtfDoc.getDocumentSettings();
    }
}

